block('b-campaign-group').mod('type', 'cpm-yndx-frontpage')(
    elem('cpm-yndx-frontpage-price-warnings-text').content()(function() {
        var TRUNCATE_LENGTH = 125,
            params = this.ctx.params,
            regions = params.regions,
            warningText = u['text-store'].get.apply(u['text-store'], [
                { backendParams: { regions: regions } },
                'cpm-yndx-frontpage',
                this.ctx.code
            ]);

        return [
            u.hellipCut(warningText, TRUNCATE_LENGTH),
            warningText.length > TRUNCATE_LENGTH && {
                block: 'dropdown',
                content: [
                    {
                        block: 'b-campaign-group',
                        elem: 'cpm-yndx-frontpage-price-warnings-text-more',
                        mix: [{ block: 'dropdown', elem: 'switcher' }],
                        content: [
                            '&nbsp;&ndash; ',
                            iget2('b-group-regions', 'vsego', 'всего'),
                            '&nbsp;',
                            {
                                block: 'link',
                                mods: { pseudo: 'yes' },
                                mix: [{
                                    block: 'b-group-regions',
                                    elem: 'switcher'
                                }],
                                content: u.pluralize([iget2('b-group-regions', 'region', 'регион'), iget2('b-group-regions', 'regiona', 'региона'), iget2('b-group-regions', 'regionov', 'регионов')], regions.length, '&nbsp;')
                            }
                        ]
                    },
                    {
                        elem: 'popup',
                        js: { directions: 'bottom-center' },
                        content: {
                            block: 'b-campaign-group',
                            elem: 'cpm-yndx-frontpage-price-warnings-regions-list',
                            content: regions.map(function(r) { return r.nameRu; }).join(', ')
                        }
                    }
                ]
            }
        ];
    })
);
