BEM.DOM.decl({ name: 'b-campaign-group', modName: 'type', modVal: 'cpm-yndx-frontpage' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._cid = this.campaignModel.get('cid');
            this._adgroudId = this.groupModel.get('adgroup_id');
            this._priceControl = this.findBlockInside('b-edit-phrase-price');
            this._reinitAdGroupPriceDebounced = $.debounce(this._reinitAdGroupPrice, 150, this);

            this._priceControl && this._priceControl.on('change', this._reinitAdGroupPriceDebounced, this);

            this.channel('cpm-yndx-frontpage-min-price').on(
                'group-' + this._adgroudId + '-inited',
                this._onAdGroupPriceInited,
                this
            );
        }
    },

    _reinitAdGroupPrice: function(e, data) {
        BEM.blocks['cpm-yndx-frontpage-min-price'].initGroupsMinPrice(
            this._cid,
            [{
                geo: this.groupModel.getGeoModel().get('geo'),
                price: data.value,
                adgroup_id: this._adgroudId
            }]
        );
    },

    /**
     * Обработчик инициализации ставок для текущей группы
     * @private
     */
    _onAdGroupPriceInited: function() {
        var adGroupValidationRes = BEM.blocks['cpm-yndx-frontpage-min-price'].getGroupValidationResults([
            this._cid,
            this._adgroudId
        ]);

        if ((adGroupValidationRes.warnings || []).length) {
            this._showPriceWarnings(adGroupValidationRes.warnings);
        } else {
            this._cleanPriceWarnings();
        }

        this._runValidatePrice();
    },

    /**
     * Вызываем валидацию у контрола ставки
     * @private
     */
    _runValidatePrice: function() {
        this._priceControl && this._priceControl.lazyValidate();
    },

    /**
     * Отрисовываем предупреждения полученные в ходе валидации ставки
     * @param {Array} warnings - предупреждения в стандартном JAVA формате
     * @private
     */
    _showPriceWarnings: function(warnings) {
        var warningsTexts = [];

        warnings.forEach(function(warn) {
            warningsTexts.push(BEMHTML.apply({
                block: 'b-campaign-group',
                mods: { type: 'cpm-yndx-frontpage' },
                elem: 'cpm-yndx-frontpage-price-warnings-text',
                params: warn.params,
                code: warn.code
            }));
        });

        BEM.DOM.update(
            this.elem('cpm-yndx-frontpage-price-warnings'),
            BEMHTML.apply({
                block: 'b-campaign-group',
                elem: 'warning-rarely',
                content: {
                    block: 'b-warning-message',
                    mods: {
                        theme: 'yellow'
                    },
                    icon: {
                        block: 'icon',
                        mods: {
                            'size-12': 'info'
                        }
                    },
                    content: warningsTexts
                }
            })
        );
    },

    /**
     * Очищаем список предупреждений
     * @private
     */
    _cleanPriceWarnings: function() {
        BEM.DOM.update(
            this.elem('cpm-yndx-frontpage-price-warnings'),
            ''
        );
    }

});
