block('b-campaign-group').mod('type', 'dynamic')(

    elem('banner-preview').def()(function() {
        var group = this.ctx.group,
            banner = this.ctx.banner,
            campaign = this.data.campaign,
            groupId = group.modelId;

        // в before_moderation в поле title приходит null (как и в объект баннера)
        banner.before_moderation && (banner.before_moderation.title = u.dynamicGroupsData.getBannerTitle());

        return [
            applyCtx({
                block: 'b-campaign-group',
                elem: 'banner-id',
                banner: banner,
                canViewImageId: group.canViewImageId,
                withMobile: true
            }),
            {
                block: 'b-campaign-group',
                elem: 'preview',
                content: [
                    {
                        block: 'b-banner-preview2',
                        mods: {
                            type: 'dynamic',
                            view: 'campaign'
                        },
                        data: u[u['b-banner-preview2'].getNameByType('dynamic')]
                            .fromServer({
                                banner: banner,
                                group: group,
                                campaign: campaign
                            }),
                        modelsParams: {
                            dmsIds: {
                                bannerId: banner.modelId,
                                groupId: groupId
                            }
                        }
                    },
                    {
                        block: 'b-banner-preview2-warnings',
                        static: banner.warnings
                    }
                ]
            },
            {
                block: 'b-banner-status',
                mods: {
                    updatable: group.isBannersEditable || banner.before_moderation ? 'yes' : ''
                },
                js: {
                    modelParams: {
                        name: u.campaign.getBannerModelName('dynamic'),
                        id: banner.modelId,
                        parentName: u.campaign.getGroupModelName('dynamic'),
                        parentId: group.modelId
                    }
                },
                banner: banner,
                // DIRECT-41778: для динамический баннеров не нужно отображать статус "Идут показы предыдущей версии"
                hideOngoingShowsStatus: true
            }
        ];
    })
);
