block('b-campaign-group').mod('type', 'mobile-content').elem('banner-preview').def()(function() {
    var group = this.ctx.group,
        banner = this.ctx.banner,
        campaign = this.data.campaign,
        randPhrase = u['dm-base-group'].getRandomActivePhrase(group.phrases || []),
        groupId = group.modelId,
        groupType = group.adgroup_type;

    return [
        applyCtx({
            block: 'b-campaign-group',
            elem: 'banner-id',
            canViewImageId: group.canViewImageId,
            banner: banner
        }),
        {
            block: 'b-campaign-group',
            elem: 'preview',
            content: [
                (banner.ad_type === 'image_ad' || banner.ad_type === 'cpc_video') ?
                    {
                        block: 'b-banner-preview2',
                        mods: {
                            type: u.beminize(groupType),
                            view: 'campaign-image'
                        },
                        data: u[u['b-banner-preview2'].getNameByType(groupType, 'campaign-image')]
                            .fromServer({
                                banner: banner,
                                group: group
                            }),
                        modelsParams: {
                            dmsIds: {
                                bannerId: banner.modelId,
                                groupId: groupId,
                                mobileContentId: groupId,
                                phraseId: (randPhrase || {}).modelId
                            }
                        }
                    } :
                    {
                        block: 'b-banner-preview2',
                        mods: {
                            type: u.beminize(groupType),
                            view: 'mobile-content-campaign'
                        },
                        data: u[u['b-banner-preview2'].getNameByType(groupType)]
                            .fromServer({
                                banner: banner,
                                group: group,
                                mobileContent: group.mobile_content,
                                phrase: randPhrase,
                                campaign: campaign
                            }),
                        modelsParams: {
                            dmsIds: {
                                bannerId: banner.modelId,
                                groupId: groupId,
                                mobileContentId: groupId,
                                phraseId: (randPhrase || {}).modelId
                            }
                        }
                    },
                {
                    block: 'b-banner-preview2-warnings',
                    static: banner.warnings
                }
            ]
        },
        {
            block: 'b-banner-status',
            mods: {
                updatable: 'yes'
            },
            js: {
                modelParams: {
                    name: 'dm-mobile-content-banner',
                    id: banner.modelId,
                    parentName: 'dm-mobile-content-group',
                    parentId: group.modelId
                }
            },
            banner: banner
        }
    ];
});
