block('b-campaign-group').mod('type', 'performance')(

    elem('banner-preview').def()(function() {
        var ctx = this.ctx,
            group = ctx.group,
            banner = ctx.banner,
            campaign = this.data.campaign,
            mediaType = campaign.mediaType,
            groupType = group.adgroup_type,
            clientFeaturesAll = u.consts('clientFeaturesAll'),
            isCreativeFreeInterface = clientFeaturesAll ? clientFeaturesAll.includes('CREATIVE_FREE_INTERFACE') : false;

        return [
            !isCreativeFreeInterface && applyCtx({
                block: 'b-campaign-group',
                elem: 'banner-id',
                banner: banner
            }),
            {
                elem: 'preview',
                content: [
                    isCreativeFreeInterface ? {
                        block: 'b-dna-preview-gallery',
                        groupId: group.adgroup_id,
                        campaignId: campaign.cid,
                    } : {
                        block: 'b-banner-preview2',
                        mods: {
                            type: 'performance',
                            view: 'performance-campaign'
                        },
                        data: u[u['b-banner-preview2'].getNameByType(groupType)]
                            .fromServer({
                                banner: banner,
                                group: group,
                                campaign: campaign
                            }),
                        modelsParams: {
                            dmsIds: {
                                bannerId: banner.modelId,
                                groupId: group.modelId
                            }
                        }
                    },
                    {
                        block: 'b-banner-preview2-warnings',
                        static: banner.warnings
                    }
                ]
            },
            {
                block: 'b-banner-status',
                mods: {
                    updatable: group.isBannersEditable ? 'yes' : ''
                },
                js: {
                    modelParams: {
                        name: u.campaign.getBannerModelName(mediaType),
                        parentName: u.campaign.getGroupModelName(mediaType),
                        parentId: group.modelId,
                        id: banner.modelId
                    }
                },
                banner: banner,
                // Для ДМО не нужно отображать сообщение "Идут показы предыдущей версии баннера" в статусе
                hideOngoingShowsStatus: true
            }
        ];
    }),

    elem('group-count-label').content()(function() {
        var count = this.ctx.count;

        return ' (' + count + '&nbsp;' + u.pluralizeWord([iget2('b-campaign-group', 'banner', 'баннер'), iget2('b-campaign-group', 'bannera', 'баннера'), iget2('b-campaign-group', 'bannerov', 'баннеров')], count) + ')';
    })
);
