BEM.DOM.decl({ name: 'b-campaign-group', modName: 'type', modVal: 'performance' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._subscriptions.on(
                BEM.blocks['b-feed-filter'],
                this.domElem,
                'filter:edit:completed',
                function(e, data) {
                    data.controller.save();
                }.bind(this)
            );
        }
    },

    /**
     * Меняет отображение кол-ва баннеров в группе.
     *
     * @param {Number} count Кол-во баннеров в группе.
     * @private
     */
    _setGroupCount: function(count) {
        this.elem('group-count-label').text(
            ' (' + u.pluralize([iget2('b-campaign-group', 'banner', 'баннер'), iget2('b-campaign-group', 'bannera', 'баннера'), iget2('b-campaign-group', 'bannerov', 'баннеров')], count) + ')');
    }

}, {});
