block('b-campaign-group')(

    js()(true),

    tag()('tr'),

    elem('anchor')(
        tag()('a'),

        attrs()(function() {
            return { name: this.ctx.id }
        })
    ),

    elem('label')(
        tag()('label'),

        content()(function() {
            return ['№&nbsp;M-', this.ctx.id]
                .concat(this.ctx.imageId && [', &nbsp;M-', this.ctx.imageId]);
        }),

        attrs()(function() {
            return { for: this.ctx.idFor + '' };
        }),

        elemMod('group', 'yes').tag()('span')
    ),

    elem('hidden')(
        tag()('input'),

        attrs()(function() {
            return {
                type: 'hidden',
                name: this.ctx.name + '',
                value: this.ctx.value === null ? '' : '' + this.ctx.value
            };
        })
    ),

    elem('group-toggle').tag()('span'),

    elem('group').tag()('td'),

    elem('phrases').tag()('td'),

    elem('group-toggle').content()(function() {
        var count = this.ctx.count;

        return {
            block: 'button',
            mods: { theme: 'pseudo', size: 'xs' },
            content: {
                block: 'b-campaign-group',
                elem: 'group-toggle-text',
                mediaType: this.ctx.mediaType,
                count: count
            }
        };
    }),

    elem('group-toggle-text')(

        content()(function() {
            var mediaType = this.ctx.mediaType;

            return [
                mediaType == 'performance' || mediaType == 'mcbanner' ?
                    u.pluralize([iget2('b-campaign-group', 'banner', 'баннер'), iget2('b-campaign-group', 'bannera', 'баннера'), iget2('b-campaign-group', 'bannerov', 'баннеров')], this.ctx.count) :
                    iget2('b-campaign-group', 's-obyavl', '{foo} объявл.', {
                        foo: this.ctx.count
                    }),
                {
                    block: 'b-icon',
                    mods: { type: 'arrow-right' }
                }
            ];
        }),

        tag()('span')
    )
);
