block('b-campaign-group')(

    addJs()(function() {
        var status_info = this.data.status.info,
            mediaType = this.data.mediaType,
            platform = this.data.platform,
            featuresEnabledForOperator = this.data.features_enabled_for_operator,
            isCampaignRunningInit = status_info.moderate === 'Yes' && this.data.show === 'Yes',
            isCampaignRunning = Object.keys(status_info)
                .filter(function(key) {
                    return ['moderate', 'timetarget', 'activation', 'sum_to_pay'].indexOf(key) === -1
                })
                .reduce(function(accumulator, key) {
                    return accumulator && status_info[key] === null
                }, isCampaignRunningInit),
            cpmBannersType = this.ctx.group.cpm_banners_type,
            isCpmFeatureEnabled = featuresEnabledForOperator &&
                (featuresEnabledForOperator.banner_aiming_cpm_allowed === 1 &&
                    (mediaType === 'cpm_deals' ||
                        (mediaType === 'cpm_banner' && cpmBannersType !== 'cpm_outdoor' &&
                            cpmBannersType !== 'cpm_indoor')
                )),
            isCpmFrontpageFeatureEnabled = featuresEnabledForOperator &&
                (featuresEnabledForOperator.banner_aiming_cpm_yndx_frontpage_allowed === 1 &&
                    mediaType === 'cpm_yndx_frontpage'
                ),
            isOtherFeatureEnabled = featuresEnabledForOperator &&
                featuresEnabledForOperator.banner_aiming_allowed === 1 &&
                mediaType === 'text' && (
                    platform === 'context' ||
                    platform === 'both'
                ),
            isFeatureEnabled = isCpmFeatureEnabled || isCpmFrontpageFeatureEnabled || isOtherFeatureEnabled;

        return {
            clientId: this.data.ClientID,
            modelParams: this.ctx.modelParams,
            isPreviewHasControls: this.ctx.isPreviewHasControls,
            generalBid: this.ctx.group.banners[0].bid,
            bannerAimingAllowed: {
                isFeatureEnabled: isFeatureEnabled,
                isCampaignRunning: isCampaignRunning
            }
        };
    }),

    elem('group').content()(function() {
        var data = this.data,
            organizations = data.organizations,
            campaign = data.campaign,
            group = this.ctx.group,
            banner = u._.find(group.banners, {
                ad_type: 'text'
            }) || group.banners[0],
            tagUrlQuery = u.getUrlParams(),
            currentTagId = tagUrlQuery.tag,
            isSmartGroup = campaign.mediaType === 'performance',
            clientFeaturesAll = u.consts('clientFeaturesAll'),
            isCreativeFreeInterface = clientFeaturesAll ? clientFeaturesAll.includes('CREATIVE_FREE_INTERFACE') : false

        delete tagUrlQuery.tag;
        delete tagUrlQuery.page;

        return [
            {
                elem: 'panel',
                content: [
                    {
                        elem: 'tail'
                    },
                    (group.adgroup_id && !group.isCopyGroup) ?
                        {
                            elem: 'group-number',
                            content: iget2('b-campaign-group', 'gruppa-s', 'Группа {foo}', {
                                foo: group.adgroup_id
                            })
                        } :
                        '',
                    {
                        elem: 'header',
                        content: [
                            {
                                elem: 'anchor',
                                id: group.adgroup_id
                            },
                            this.massActions && this.massActions.keys.length > 0 && {
                                elem: 'checkbox-wrap',
                                content: {
                                    block: 'checkbox',
                                    mix: [
                                        {
                                            block: 'b-checkboxes-group',
                                            elem: 'item'
                                        },
                                        {
                                            block: 'b-campaign-group',
                                            elem: 'checkbox'
                                        }
                                    ],
                                    checkboxAttrs: {
                                        id: 'adgroupId_' + group.adgroup_id,
                                        autocomplete: 'off'
                                    }
                                }
                            },
                            (group.isNotEmptyGroup || group.isEmptyGroup) && {
                                elem: 'group-title-wrap',
                                content: [
                                    {
                                        elem: 'group-toggle',
                                        elemMods: {
                                            hidden: isSmartGroup && isCreativeFreeInterface ? 'yes' : 'no'
                                        },
                                        mediaType: campaign.mediaType,
                                        count: +group.banners_quantity
                                    },
                                    {
                                        elem: 'group-title',
                                        content: u.hellipCut(group.group_name || iget2('b-campaign-group', 'bez-nazvaniya', 'Без названия'), 50, u.escapeHTML)
                                    }
                                ]
                            }
                        ]
                    },
                    banner.tragic_enabled && {
                        elem: 'warning',
                        elemMods: {
                            type: 'tragic'
                        },
                        content: [
                            iget2('b-campaign-group', 'obyavlenie-budet-pokazano-bez', 'Объявление будет показано без изображения'),
                            {
                                block: 'b-help-link',
                                url: u.getLegalUrl('general_adv_rules')
                            }
                        ]
                    },
                    group.banners_quantity || (isSmartGroup && isCreativeFreeInterface) ?
                        {
                            elem: 'banner-preview',
                            group: group,
                            banner: banner,
                            organization: banner.permalink && organizations[banner.permalink],
                            campaign: campaign
                        } :
                        {
                            block: 'b-empty-group-preview',
                            mods: {
                                type: u.beminize(group.adgroup_type)
                            },
                            modelParams: this.ctx.modelParams
                        },
                    group.is_completed_group === 0 && group.banners_quantity > 0 && {
                        block: 'b-warning-message',
                        mods: {
                            type: 'preview'
                        },
                        icon: {
                            block: 'icon',
                            mods: {
                                'size-12': 'alert'
                            }
                        },
                        content: [
                            iget2('b-campaign-group', 'otsutstvuyut-ili-otklyucheny-usloviya', 'Отсутствуют или отключены условия показа'),
                            {
                                block: 'b-help-link',
                                mods: {
                                    type: 'modal'
                                },
                                mix: {
                                    block: 'b-warning-message',
                                    elem: 'link'
                                },
                                stretched: true,
                                url: u.getHelpUrl('no-impression-criteria'),
                                text: iget2('b-campaign-group', 'podrobnee', 'Подробнее')
                            }
                        ]
                    },
                    {
                        elem: 'warning',
                        elemMods: { type: 'oversized-phrases' },
                        content: iget2('b-campaign-group', 'prevysheno-kolichestvo-klyuchevyh-fraz', 'Превышено количество ключевых фраз на группу')
                    },
                    {
                        elem: 'warning',
                        elemMods: { type: 'phrase-exceed-max-length' },
                        content: iget2(
                            'b-campaign-group',
                            'prevyshena-maksimalnaya-razreshennaya-dlina',
                            'Превышена максимальная разрешенная длина ключевой фразы'
                        )
                    },
                    {
                        elem: 'warning',
                        elemMods: { type: 'phrase-exceed-max-words' },
                        content: iget2('b-campaign-group', 'prevysheno-kolichestvo-slov-v', 'Превышено количество слов в ключевой фразе')
                    },
                    {
                        elem: 'warning',
                        elemMods: { type: 'net-stop' },
                        content: iget2('b-campaign-group', 'otklyucheny-pokazy-v-seti', 'Отключены показы в сети. Показ графических объявлений невозможен.')
                    },
                    //DIRECT-39957 - идейно эти предупреждения на группу, но пока показываем их в блоке баннера
//                    {
//                        elem: 'warning',
//                        elemMods: { type: 'common' },
//                       content: iget('Объявление не показывается. Отключены показы на тематических площадках')
//                    },
//                    {
//                        elem: 'warning',
//                        elemMods: { type: 'retargeting' },
//                       content: iget('Отключены показы на тематических площадках. Показ по условиям ретаргетинга невозможен.')
//                    },
                    {
                        block: 'b-banner-actions',
                        mix: [{
                            block: 'b-campaign-group',
                            elem: 'actions'
                        }],
                        actions: group.actions,
                        isGroup: group.isNotEmptyGroup
                    }
                ]
            },
            !!group.mobile_content_id && hasLoginRights('support_control', 'super_control', 'superreader_control') && {
                elem: 'mobile-content-id',
                content: [
                    'mobile_content_id:',
                    '&nbsp;',
                    group.mobile_content_id
                ]
            },

            data.tags_allowed == 'Yes' && withUidPar({
                block: 'b-group-tags',
                mix: [{
                    block: 'b-campaign-group',
                    elem: 'tags'
                }],
                group: group,
                modelParams: this.ctx.modelParams,
                tagUrl: u.formatUrl({
                    host: data.SCRIPT,
                    query: tagUrlQuery
                }),
                switcher: {
                    block: 'b-group-tag-button',
                    content: iget2('b-campaign-group', 'metki', 'Метки')
                },
                campaignTags: this.data.campaign.tags,
                currentTagId: currentTagId,
                useBanner: this.data.campaign.mediaType == 'mcbanner' || this.data.campaign.mediaType == 'performance'
            })

        ];
    }),

    elem('phrases')(

        content()(function() {
            var res = [],
                group = this.ctx.group,
                data = this.data,
                strategy = data.campaign.strategy,
                isNetStop = Boolean(+strategy.is_net_stop),
                isSearchStop = Boolean(+strategy.is_search_stop),
                isDifferentPlaces = strategy.name == 'different_places',
                isSearchRetargetingEnabled = u.consts('isSearchRetargetingEnabled');

            // search - список условий показа для таба "На поиске"
            // context - список условий показа для таба "В сетях"
            // default - список условий показа для кейса,
            // когда  условия показа на поиске и в сетях разделять на разные табы не нужно - разделяют,
            // так как ставки для фраз разные на площадках могут быть
            // (во всех кейсах, кроме ручной стратегии с показами на поиске
            // и в сетях, и почему-то во всех стратегиях с показами в сетях)
            ['search', 'context', 'default'].forEach(function(name) {
                if (isDifferentPlaces && (name == 'context' || strategy.search.name !== 'stop' && name == 'search') ||
                    !isDifferentPlaces && name == 'default' && !isSearchRetargetingEnabled ||
                    // если ретаргетинги на поиске доступны - управление им на поиске и в сетях нужно разделить,
                    // для разных площадок может быть разный набор ретаргетингов, их нужно уметь раздельно удалять,
                    // редактирование ставок на поиске недоступно, а в сетях доступно
                    isSearchRetargetingEnabled && !isDifferentPlaces && (name == 'context' && !isNetStop || name == 'search' && !isSearchStop)
                ) {
                    res.push({
                        elem: 'phrases-data', // оборачиваем в доп елемент, чтобы работала переключалка На поиске/в сетях
                        elemMods: {
                            platform: name
                        },
                        content: [
                            +group.is_bs_rarely_loaded == 1 && {
                                elem: 'warning-rarely',
                                group: group
                            },
                            {
                                block: 'b-phrases-list',
                                mods: {
                                    platform: name,
                                    'show-autobroker': 'no',
                                    loading: 'yes'
                                },
                                group: group
                            }
                        ]
                    });
                }
            });

            return res;
        }),

        elemMod('type', 'cpm-banner').content()(function() {
            var group = this.ctx.group;

            return [
                +group.is_bs_rarely_loaded == 1 && {
                    elem: 'warning-rarely',
                    group: group
                },
                {
                    block: 'b-phrases-list',
                    mods: {
                        platform: 'context',
                        'show-autobroker': 'no',
                        loading: 'yes'
                    },
                    group: group
                }
            ]
        }),

        elemMod('type', 'cpm-yndx-frontpage').content()(function() {
            var group = this.ctx.group;

            return [
                +group.is_bs_rarely_loaded == 1 && {
                    elem: 'warning-rarely',
                    group: group
                },
                { elem: 'cpm-yndx-frontpage-price-warnings' },
                {
                    block: 'b-phrases-list',
                    mods: {
                        platform: 'context',
                        'show-autobroker': 'no',
                        loading: 'yes'
                    },
                    group: group
                }
            ]
        }),

        elemMod('type', 'dynamic').content()(function() {
            var res = [],
                group = this.ctx.group,
                data = this.data,
                strategy = data.campaign.strategy;

            ['search', 'context', 'default'].forEach(function(name) {
                if (strategy.name == 'different_places' &&
                    (name == 'context' || strategy.search.name !== 'stop' && name == 'search') ||
                        strategy.name != 'different_places' && name == 'default') {

                    if (group.main_domain) { //какой источник данных выбран - фид или сайт
                        res.push({
                            elem: 'phrases-data', // оборачиваем в доп елемент, чтобы работала переключалка На поиске/в сетях
                            elemMods: {
                                platform: name
                            },
                            content: [
                                +group.is_bs_rarely_loaded == 1 && {
                                    elem: 'warning-rarely',
                                    group: group
                                },
                                {
                                    block: 'b-dynamic-conditions-table',
                                    mods: {
                                        platform: name,
                                        'show-autobroker': 'no',
                                        loading: 'yes'
                                    },
                                    group: group
                                }
                            ]
                        });
                    } else {
                        +group.is_bs_rarely_loaded == 1 && res.push({
                            elem: 'warning-rarely',
                            group: group
                        });
                        res.push({
                            block: 'b-campaign-group',
                            elem: 'feeds-filters',
                            group: group
                        });
                    }
                }
            });

            return res;
        }),

        elemMod('type', 'performance').content()(function() {
            return [
                +this.ctx.group.is_bs_rarely_loaded == 1 && {
                    elem: 'warning-rarely',
                    group: this.ctx.group
                },
                {
                    block: 'b-campaign-group',
                    elem: 'feeds-filters',
                    group: this.ctx.group
                }
            ];
        }),

        elemMod('empty', 'yes')(

            content()(function() {
                return {
                    elem: 'empty-phrases-label',
                    mix: {
                        block: 'b-style-table',
                        mods: {
                            theme: 'bordered'
                        }
                    },
                    content: iget2('b-campaign-group', 'net-klyuchevyh-fraz', 'Нет ключевых фраз')
                };
            }),

            elemMod('type', 'performance').content()(function() {
                return {
                    elem: 'empty-phrases-label',
                    mix: {
                        block: 'b-style-table',
                        mods: {
                            theme: 'bordered'
                        }
                    },
                    content: iget2('b-campaign-group', 'net-filtrov', 'Нет фильтров')
                };
            })
        )

    ),

    elem('feeds-filters').def()(function() {
        var strategy = this.data.campaign.strategy,
            strategyMod = u.campaign.getFilterPricesControlsMod(this.ctx.group.adgroup_type, strategy),
            campaignIsArchived = this.data.archived === 'Yes',
            platform = strategy.is_net_stop ? 'search' : strategy.is_search_stop ? 'net' : 'all';

        return {
            block: 'b-feed-filters-table',
            mods: {
                loading: 'yes',
                platform: 'default',
                strategy: strategyMod
            },
            group: this.ctx.group,
            nowOptimizingBy: this.data.campaign.strategy.net.now_optimizing_by,
            currency: this.data.campaign.currency,
            showStat: this.data.OrderID != '0' && !campaignIsArchived,
            campaignIsArchived: campaignIsArchived,
            platform: platform
        };
    }),

    //             Подсказка про отсутствие активного мобильного/desktop объявления, данных пока нет (спрятал по DIRECT-41019)
    //             cyn@TODO: Решение по этому куску будет принято в DIRECT-42222
    //            {
    //                block: 'dropdown',
    //                mix: [{ block: 'b-campaign-group', elem: 'tooltip' }],
    //                content: [
    //                    {
    //                        block: 'b-icon',
    //                        mix: [{ block: 'dropdown', elem: 'switcher' }, { block: 'b-campaign-group', elem: 'tooltip-icon' }],
    //                        mods: { type: 'red-desktop' }
    //                    },
    //                    {
    //                        elem: 'popup',
    //                        elemMods: { adaptive: 'no' },
    //                        js: {
    //                            directions: { to: 'top', offset: { left: 80 }, tail: { axis: 'middle' } }
    //                        },
    //                        content: [
    //                            iget('В группе нет активного мобильного объявления'),  //В группе нет активного объявления для десктопа
    //                            {
    //                                block: 'b-help-link',
    //                                icon: 'question',
    //                                url: ''
    //                            }
    //                        ]
    //                    }
    //                ]
    //            }

    elem('banner-preview').def()(function() {
        var ctx = this.ctx,
            group = ctx.group,
            banner = ctx.banner,
            campaign = ctx.campaign,
            organization = ctx.organization,
            randPhrase = u['dm-base-group'].getRandomActivePhrase(group.phrases || []),
            mediaType = campaign.mediaType,
            groupType = group.adgroup_type;

        return [
            applyCtx({
                block: 'b-campaign-group',
                elem: 'banner-id',
                banner: banner,
                canViewImageId: group.canViewImageId,
                withMobile: true
            }),
            {
                elem: 'preview',
                content: [
                    u._.contains([
                        'image_ad',
                        'mcbanner',
                        'cpm_banner',
                        'cpm_deals',
                        'cpc_video',
                        'cpm_yndx_frontpage',
                        'cpm_price'
                    ], banner.ad_type) ?
                        {
                            block: 'b-banner-preview2',
                            mods: {
                                type: u.beminize(groupType),
                                view: u._.contains([
                                    'cpm_deals',
                                    'cpm_banner',
                                    'cpm_yndx_frontpage',
                                    'cpm_price'
                                ], banner.ad_type) ?
                                    'campaign-creative' :
                                    'campaign-image'
                            },
                            data: u[u['b-banner-preview2'].getNameByType(groupType, 'campaign-image')]
                                .fromServer({
                                    banner: banner,
                                    group: group
                                }),
                            modelsParams: {
                                dmsIds: {
                                    bannerId: banner.modelId,
                                    groupId: group.modelId,
                                    mobileContentId: group.groupId,
                                    phraseId: (randPhrase || {}).modelId
                                }
                            }
                        } :
                        {
                            block: 'b-banner-preview2',
                            mods: {
                                type: u.beminize(groupType),
                                view: 'campaign'
                            },
                            data: u[u['b-banner-preview2'].getNameByType(groupType)]
                                .fromServer({
                                    banner: banner,
                                    group: group,
                                    phrase: randPhrase,
                                    campaign: campaign,
                                    organization: organization
                                }),
                            modelsParams: {
                                dmsIds: {
                                    bannerId: banner.modelId,
                                    groupId: group.modelId,
                                    phraseId: (randPhrase || {}).modelId
                                }
                            },
                            js: {
                                hasOrganization: !!organization,
                                preferVcardOverPermalink: banner.prefer_vcard_over_permalink
                            }
                        },
                    {
                        block: 'b-banner-preview2-warnings',
                        static: banner.warnings,
                        useBanner: campaign.mediaType === 'mcbanner' || campaign.mediaType === 'performance'
                    }
                ]
            },
            {
                block: 'b-banner-status',
                mods: {
                    updatable: group.isBannersEditable || banner.before_moderation ? 'yes' : ''
                },
                js: {
                    modelParams: {
                        name: u.campaign.getBannerModelName(mediaType),
                        parentName: u.campaign.getGroupModelName(mediaType),
                        parentId: group.modelId,
                        id: banner.modelId
                    }
                },
                banner: banner
            }
        ];
    }),

    elem('warning').content()(function() {
        return [
            {
                block: 'icon',
                mods: {
                    'size-13': 'alert'
                },
                mix: [{
                    block: 'b-campaign-group',
                    elem: 'warning-icon'
                }]
            },
            this.ctx.content
        ];
    }),

    elem('warning-rarely').content()(function() {
        return {
            block: 'b-warning-message',
            icon: {
                block: 'icon',
                mods: {
                    'size-12': 'alert'
                }
            },
            content: [
                iget2('b-campaign-group', 'malo-pokazov-po-dannoy', 'Мало показов по данной группе. Попробуйте изменить настройки'),
                '&nbsp;&nbsp;',
                {
                    block: 'b-help-link',
                    mods: {
                        type: 'modal'
                    },
                    mix: {
                        block: 'b-warning-message',
                        elem: 'link'
                    },
                    stretched: true,
                    url: u.getHelpUrl(u.getRarelyServedHelpId({
                        groupType: this.ctx.group.adgroup_type
                    })),
                    text: iget2('b-campaign-group', 'podrobnee', 'Подробнее')
                }
            ]
        };
    })

);
