/**
 * @listens b-feed-filter#filter:edit:completed
 */
BEM.DOM.decl('b-campaign-group', {
    onSetMod: {
        js: function() {
            this.modelParams = this.params.modelParams;
            this._subscriptions = BEM.create('i-subscription-manager');

            this.groupModel = BEM.MODEL.getOrCreate(this.modelParams);
            this.groupToggleBtn = this.findBlockInside('group-toggle', 'button')
                .on('click', this.toggleGroupPreview, this);

            this.campaignModel = this.groupModel.getCampaignModel()
                .on('platform', 'change', function() {
                    this.setMod('platform', this.campaignModel.get('platform'));
                }, this);

            this._bindToChangeBannersCount();
        }
    },

    /**
     * @override {BEM.DOM}
     */
    destruct: function() {
        this._subscriptions.dispose();

        return this.__base.apply(this, arguments);
    },

    /**
     * Подписка на изменение количества баннеров в группе
     * @private
     */
    _bindToChangeBannersCount: function() {
        this.groupModel
            .on('banners_quantity', 'change', function(e, data) {
                this._setGroupCount(data.value);
            }, this)
            .on('banners_arch_quantity', 'change', function(e, data) {
                this.campaignModel.isArchiveTab() &&
                    this._setArchiveLinkText(this.groupModel.get('banners_quantity') === data.value ?
                        iget2('b-campaign-group', 'razarhivirovat-gruppu', 'Разархивировать группу') :
                        iget2('b-campaign-group', 'razarhivirovat-vse', 'Разархивировать все'))
            }, this)
    },

    getGroupModel: function() {
        return this.groupModel;
    },

    /**
     * Показывает/скрывает превью для групп баннеров
     * @returns {BEM}
     */
    toggleGroupPreview: function() {
        BEM.blocks['b-group-preview2'].showGroupPopup({
            campaignMediaType: this.campaignModel.get('mediaType'),
            groupId: this.groupModel.get('modelId'),
            groupType: this.groupModel.get('adgroup_type'),
            cpmGroupType: this.groupModel.get('cpmGroupType'),
            readonly: !this.params.isPreviewHasControls,
            generalBid: this.params.generalBid,
            clientId: this.params.clientId,
            owner: this.groupToggleBtn.domElem,
            bannerAimingAllowed: this.params.bannerAimingAllowed,
        });

        return this;
    },

    /**
     * Инициализирует и возвращает bem-блок попапа, в котором будет показываться превью группы
     * @returns {BEM}
     */
    getGroupPreviewPopup: function() {
        return this._popup || (this._popup = BEM.blocks['b-shared-popup'].getInstance({
            animate: 'yes',
            name: 'group-preview',
            'has-close': 'yes'
        }, { directions: ['right-middle-middle', 'top-left-right', 'bottom-left-right'] }));
    },

    /**
     * Меняет текст ссылки действия разархивировать.
     *
     * @param {String} text Текст ссылки.
     * @private
     */
    _setArchiveLinkText: function(text) {
        var link = this._getArchiveLink();

        link && link.domElem && link.domElem.text(text);
    },

    /**
     * Меняет отображение кол-ва баннеров в группе.
     *
     * @param {Number} count Кол-во баннеров в группе.
     * @private
     */
    _setGroupCount: function(count) {
        this.groupToggleBtn.elem('text').html(BEMHTML.apply({
            block: 'b-campaign-group',
            elem: 'group-toggle-text',
            mediaType: this.campaignModel.get('mediaType'),
            count: count
        }));
    },

    /**
     * Получает элемент ссылки действия разархивировать.
     */
    _getArchiveLink: function() {
        return this._archivLink || (this._archivLink = this.findBlockInside({
            block: 'b-banner-actions-link',
            modName: 'type',
            modVal: 'unarchive'
        }));
    }
}, {});
