block('b-campaign-help-request')(

    addJs()(function() {
        return {
            currency: this.data.campaign.currency
        };
    }),

    content()(function() {
        return {
            block: 'b-layout-form',
            mix: [{
                block: 'i-form',
                mods: {
                    submit: 'bem-event'
                }
            }, {
                block: 'b-campaign-help-request',
                elem: 'form'
            }],
            mixes: {
                submit: [{
                    block: 'b-campaign-help-request',
                    elem: 'submit'
                }]
            },
            action: this.data.script,
            header: iget2('b-campaign-help-request', 'zayavka-na-pervuyu-pomoshch', 'Заявка на Первую помощь'),

            rows: [
                {
                    label: {
                        for: 'budget-input',
                        content: [
                            iget2('b-campaign-help-request', 'nedelnyy-byudzhet', 'Недельный бюджет'),
                            ', ',
                            u.currencies.getName(this.data.campaign.currency)
                        ]
                    },
                    control: {
                        block: 'input',
                        name: 'budget',
                        id: 'budget-input',
                        mix: [{
                            block: 'b-campaign-help-request',
                            elem: 'week-budget'
                        }],
                        content: {
                            elem: 'control'
                        }
                    }
                },
                {
                    label: {
                        for: 'comment-input',
                        content: iget2('b-campaign-help-request', 'pozhelaniya-klienta', 'Пожелания клиента')
                    },
                    control: [
                        {
                            block: 'input',
                            id: 'comment-input',
                            name: 'request_comment',
                            mods: {
                                type: 'textarea',
                                counter: 'yes'
                            },
                            limit: 300,
                            mix: [{
                                block: 'b-campaign-help-request',
                                elem: 'client-comment'
                            }],
                            content: {
                                elem: 'control',
                                attrs: {
                                    cols: '50',
                                    rows: '4'
                                }
                            }
                        }
                    ]
                }

            ],

            hiddenInputs: [
                {
                    name: 'cmd',
                    value: 'sendCampaignOptimizingOrder'
                },
                {
                    name: 'by_support',
                    value: '1'
                },
                {
                    name: 'cid',
                    value: this.data.campaign.cid
                },
                {
                    name: 'ulogin',
                    value: this.data.user_login
                },
                {
                    name: 'tab',
                    value: this.data.FORM.tab
                }
            ],

            submit: iget2('b-campaign-help-request', 'otpravit', 'Отправить')
        };
    })
);
