(function() {
    var confirm = BEM.blocks['b-confirm'];

    BEM.DOM.decl('b-campaign-help-request', {

        onSetMod: {

            js: function() {
                this._budget = this.findBlockOn('week-budget', 'input');
                this._comment = this.findBlockOn('client-comment', 'input');
                this._submit = this.findBlockInside('submit', 'button');

                this._limit = 300;
                //Значение минимального бюджета первой помощи совпадает со значением минимального автобюджета
                //@see https://st.yandex-team.ru/DIRECT-38970#1423817070000
                this._minBudget = u.currencies.getConst(this.params.currency, 'MIN_AUTOBUDGET');
                this._popup = this.findBlockOutside('popup');

                var _this = this;

                this.findBlockOn('form', 'i-form').on('submit', function() {
                    [_this._budget, _this._comment, _this._submit].forEach(function(block) {
                        block.delMod('focused');
                    });
                    _this.validate() && this.submit();
                });
            }

        },

        validate: function() {
            var budget = this._budget.val();

            if (!budget.length) {
                confirm.alert(iget2('b-campaign-help-request', 'vvedite-byudzhet-dlya-pervoy', 'Введите бюджет для первой помощи'), this._popup);

                return false;
            }

            if (!budget.match(/\d+/)) {
                confirm.alert(iget2('b-campaign-help-request', 'oshibka-nekorrektno-zadan-byudzhet', 'Ошибка! Некорректно задан бюджет!'), this._popup);

                return false;
            }

            if (budget < this._minBudget) {
                var sum = u.currencies.formatSum(this.params.currency, this._minBudget);

                confirm.alert(iget2('b-campaign-help-request', 'oshibka-minimalnyy-byudzhet-pervoy', 'Ошибка! Минимальный бюджет первой помощи - {foo}', {
                    foo: sum
                }), this._popup);

                return false;
            }

            if (this._comment.val().length > this._limit) {
                confirm.alert(iget2('b-campaign-help-request', 'pozhelaniya-klienta-ne-dolzhny', 'Пожелания клиента не должны превышать {foo} символов', {
                    foo: this._limit
                }), this._popup);

                return false;
            }

            return true;
        }

    });
})();
