BEM.DOM.decl({ block: 'b-campaign-info-panel', modName: 'type', modVal: 'corrections' }, {
    onSetMod: {
        js: function() {
            this.__base();

            this._getCampModel()
                .on('corrections', function(e, corrections) {
                    this.addCorrectionsMessage(corrections);
                }, this);
        }
    },

    /**
     * Удаляет все сообщения на панели
     * @returns {BEM}
     */
    clear: function() {
        this.elem('unglued-message').empty();
        this.elem('stopword-fixated-message').empty();

        return this;
    },

    /**
     * Добавляем блок с сообщением о том, что фраза скорректирована
     * @param {Object} corrections
     * @returns {BEM}
     */
    addCorrectionsMessage: function(corrections) {
        this.clear();
        this.toggle(true);
        ['unglued', 'stopword-fixated'].map(function(name) {
            corrections[name].length && BEM.DOM.update(this.elem(name + '-message'), BEMHTML.apply({
                block: 'b-phrases-corrections-message',
                modelParams: this.params.modelParams,
                mods: { ajax: 'yes' },
                type: name,
                corrections: corrections[name]
            }));
        }, this);

        return this;
    }
});
