BEM.DOM.decl({ block: 'b-campaign-info-panel', modName: 'type', modVal: 'errors' }, {

    onSetMod: {

        js: function() {
            this.__base();

            this.renderErrors = $.debounce(this.renderErrors, 100);

            this.errors = {};

            this._getCampModel()
                .on('error', function(e, errors) {
                    errors.forEach(function(error) {
                        //все ошибки - ответ от сервера обрабатываются как "ошибки кампании"
                        //добавление phraseModelId в ключ - такой способ отобразить несколько "ошибок кампании", если они на самом деле про фразы
                        //alkaline@todo DIRECT-58754
                        this.updateError('campaign-' + error.text + (error.phraseModelId ? error.phraseModelId : ''), {
                            adgroupId: error.bid || error.adgroupId,
                            text: u.escapeHTML(error.text),
                            phraseModelId: error.phraseModelId,
                            type: error.type,
                            phrase: error.phrase
                        });
                    }, this);
                }, this);

            this._initEventsListeners(this._getCampModel().get('mediaType'));
        }

    },

    /**
     * Обновляет хэш ошибок по ключу-идентификатору
     * @param {Number|String} idKey
     * @param {Object} value
     */
    updateError: function(idKey, value) {
        this.errors[idKey] = value;
        this.renderErrors();
    },

    /**
     * Удаляет ошибку из хэша ошибок по ключу-идентификатору
     * @param {Number} idKey
     */
    removeError: function(idKey) {
        delete this.errors[idKey];
        this.renderErrors();
    },

    /**
     * Отрисовывает блок с ошибками и предупреждениями
     */
    renderErrors: function() {
        this.clear();

        if (!Object.keys(this.errors).length) {
            this.toggle(false);
            this.trigger('validated', { isValid: true });
        } else {
            BEM.DOM.update(this.elem('messages'), BEMHTML.apply({
                block: 'b-campaign-info-panel',
                elemMods: { type: 'errors' },
                elem: 'errors',
                errors: Object.keys(this.errors).map(function(key) {
                    return this.errors[key];
                }, this)
            }));
            this.toggle(true);
            this.trigger('validated', { isValid: false });
        }

        Object.keys(this.errors).forEach(function(key) { //общие ошибки показываем только раз
            if (/^campaign-/.test(key)) delete this.errors[key];
        }, this);
    },

    /**
     * Инициализирует слушателей событий моделей
     * @param {String} mediaType медиа тип кампании
     * @private
     */
    _initEventsListeners: function(mediaType) {
        if (mediaType == 'performance') {
            //в смарт-кампаниях есть только фиды
            this._initFeedFilterListeners();
        } else if (mediaType == 'dynamic') {
            //в ДО кампаниях есть фиды и условия нацеливания
            this._initDynamicConditionListeners();
            this._initFeedFilterListeners();
        } else if (u._.contains([
            'text',
            'mobile_content',
            'mcbanner',
            'cpm_banner',
            'cpm_deals',
            'cpm_yndx_frontpage'
        ], mediaType)) {
            this._initPhraseAndRetargetingListeners();
        }
    },

    /**
     * Инициализирует слушателей событий моделей фраз и условий ретаргетинга
     * @private
     */
    _initPhraseAndRetargetingListeners: function() {
        ['m-phrase-bidable', 'm-retargeting-bidable', 'm-interest-bidable', 'm-relevance-match']
            .forEach(function(modelName) {
                BEM.MODEL.on({
                    name: modelName,
                    parentName: this._getCampModel().getChildGroupModelName(),
                    parentId: '*'
                }, 'validated', function(e, data) {
                    var model = e.target,
                        //пользуемся уникальным id модели, а не id фразы/условия, которое может быть нулевое для новой фразы
                        phraseModelId = model.get('modelId');
                    if (data.valid) {
                        this.removeError(phraseModelId);
                    } else {
                        var isRetargeting = model.name == 'm-retargeting-bidable',
                            isInterest = model.name == 'm-interest-bidable',
                            isRelevanceMatch = model.name == 'm-relevance-match',
                            phraseName = {
                                'm-retargeting-bidable': model.get('condition_name_escape'),
                                'm-interest-bidable': model.get('interest_name_escape'),
                                'm-relevance-match': iget2('b-campaign-info-panel', 'avtotargeting', 'Автотаргетинг')
                            }[model.name] || u.hellipCut(model.get('phrase'), 40, u.escapeHTML);
                        data.errors.forEach(function(error) {
                            this.updateError(phraseModelId, {
                                adgroupId: model.get('adgroup_id'),
                                phraseModelId: phraseModelId,
                                isRetargeting: isRetargeting,
                                isInterest: isInterest,
                                isRelevanceMatch: isRelevanceMatch,
                                phrase: phraseName,
                                text: error.text
                            });
                        }, this);
                    }
                }, this);
            }, this);
    },

    /**
     * Инициализирует слушателей событий моделей для условий нацеливания (используется в ДО кампаниях)
     * @private
     */
    _initDynamicConditionListeners: function() {
        BEM.MODEL.on({ name: 'dm-dynamic-condition' }, 'validated', function(e, data) {
            var model = e.target,
                modelId = model.get('dyn_id');

            if (data.valid) {
                this.removeError(modelId);
            } else {
                data.errors.forEach(function(error) {
                    this.updateError(modelId, {
                        adgroupId: model.get('adgroup_id'),
                        phraseModelId: modelId,
                        type: 'dynamic-condition',
                        phrase: model.get('condition_name'),
                        text: error.text
                    });
                }, this);
            }
        }, this);
    },

    /**
     * Инициализирует слушателей событий моделей для фильтров по фиду (используется в ДМО и ДО кампаниях)
     * @private
     */
    _initFeedFilterListeners: function() {
        BEM.MODEL.on({ name: 'dm-feed-filter' }, 'use_default_price', 'change', function(e, data) {
            data.value && e.target.model.validate();
        });

        BEM.MODEL.on({ name: 'dm-feed-filter' }, 'validated', function(e, data) {
            // при валидации конкретного поля не показываем плашку с ошибками
            if (data.field) return;

            var model = e.target,
                modelId = model.get('filter_id');

            if (data.valid) {
                this.removeError(modelId);
            } else {
                this.updateError(modelId, {
                    adgroupId: model.get('adgroup_id'),
                    phraseModelId: modelId,
                    type: 'feed-filter',
                    phrase: u.hellipCut(model.get('filter_name'), 40, u.escapeHTML),
                    text: data.errors.map(function(error) { return u.escapeHTML(error.text); }, this)
                });
            }
        }, this);
    }

});
