BEM.DOM.decl('b-campaign-info-panel', {
    onSetMod: {
        js: function() {
            this.bindTo('close', 'click', function() {
                this.toggle(false);
            });
        }
    },

    _getCampModel: function() {
        return this.campModel || (this.campModel = BEM.MODEL.getOrCreate(this.params.modelParams));
    },

    /**
    * Удаляет все сообщения на панели
    * @returns {BEM}
    */
    clear: function() {
        this.elem('messages').empty();

        return this;
    },

    /**
     * Показать/скрыть панель информации
     * @param {Boolean} isShown - показать/скрыть
     * @returns {BEM}
     */
    toggle: function(isShown) {
        this.setMod('hidden', isShown ? 'no' : 'yes');
        this.trigger('visibility_changed');

        return this;
    }
});
