block('b-campaign-info').elem('actions-bar').content()(function() {
    var data = this.data,
        migration = this.ctx.migration,
        actionsBar = this.ctx.actionsBar,
        optimizeCamp = actionsBar.optimizeCamp || {},
        campaign = data.campaign,
        mediaType = campaign.mediaType,
        hasOldAddBannerButton = actionsBar.addBannerMultiEdit && !migration.oldEditDenied,
        hasNewAddBannerButton = actionsBar.addBannerMultiEdit && migration.newEditAllowed,
        campaignHasSurvey = Boolean(campaign.brand_survey_id);

    return {
        elem: 'actions-bar-layout',
        content: [
            actionsBar.showModerate && {
                elem: 'actions-bar-item',
                content: [
                    {
                        block: 'b-layout-form',
                        mix: [
                            {
                                block: 'b-metrika',
                                js: {
                                    event: 'click',
                                    goals: [
                                        {
                                            name: 'DIRECT-MODERATION',
                                            visitParams: u.getMetrikaVisitParams({
                                                'yd.point_moderate_order': true,
                                                'yd.first': (data.has_text_camps == 0 && data.has_media_camps == 0)
                                            })
                                        }
                                    ]
                                }
                            },
                            {
                                block: 'b-metrika2',
                                js: {
                                    nativeEvent: 'click',
                                    params: {
                                        showCamp: 'moderate'
                                    },
                                    goal: {
                                        target: 'SEND_TO_MODERATION_CLICKED',
                                        id: 191494
                                    }
                                }
                            }
                        ],
                        action: data.script,
                        hiddenInputs: [
                            {
                                name: 'cid',
                                value: campaign.cid
                            },
                            {
                                name: 'cmd',
                                value: 'orderCamp'
                            },
                            {
                                name: 'ulogin',
                                value: data.user_login
                            },
                            actionsBar.isOrderAgree || u.consts('isModerationsOfferFeatureEnabled') && {
                                name: 'agree',
                                value: 'yes'
                            }
                        ],
                        submit: {
                            block: 'button',
                            type: campaignHasSurvey ? undefined : 'submit',
                            mods: campaignHasSurvey ? { action: 'send-to-moderate-campaign-with-survey' } : undefined,
                            content: iget2('b-campaign-info', 'otpravit-na-moderaciyu', 'Отправить на модерацию')
                        }
                    }
                ]
            },
            actionsBar.showModerate && (hasOldAddBannerButton || hasNewAddBannerButton) && {
                elem: 'actions-bar-item',
                content: iget2('b-campaign-info', 'ili', 'или')
            },

            hasOldAddBannerButton && {
                elem: 'actions-bar-item',
                content: [
                    {
                        block: 'b-layout-form',
                        mix: [{
                            block: 'b-campaign-info',
                            elem: 'main-form'
                        }, {
                            block: 'i-form'
                        }],
                        action: data.script,
                        hiddenInputs: [
                            {
                                name: 'cid',
                                value: campaign.cid
                            },
                            {
                                name: 'new_group',
                                value: 1
                            },
                            {
                                name: 'cmd',
                                value: u.campaign.getAddCmdByMediaType(mediaType),
                                mix: [{
                                    block: 'b-campaign-info',
                                    elem: 'cmd-input'
                                }]
                            },
                            {
                                name: 'ulogin',
                                value: data.user_login
                            },
                            {
                                name: 'optimize_camp',
                                value: optimizeCamp.status
                            },
                            {
                                name: 'optimizationComment',
                                mix: [{
                                    block: 'b-campaign-info',
                                    elem: 'opt-accept-comment'
                                }]
                            },
                            {
                                name: 'optimizationDeclineComment',
                                mix: [{
                                    block: 'b-campaign-info',
                                    elem: 'opt-decline-comment'
                                }]
                            },
                            {
                                name: 'optimizationDeclineReason',
                                mix: [{
                                    block: 'b-campaign-info',
                                    elem: 'opt-decline-reason'
                                }]
                            },
                            {
                                name: 'optType',
                                value: 'acceptOptimize',
                                mix: [{
                                    block: 'b-campaign-info',
                                    elem: 'opt-type'
                                }]
                            },
                            {
                                name: 'optimize_request_id',
                                value: optimizeCamp.request_id
                            }
                        ],
                        submit: {
                            block: 'button',
                            mix: {
                                block: 'b-metrika2',
                                js: {
                                    blockName: 'button',
                                    event: 'click',
                                    params: {
                                        showCamp: 'add-group'
                                    }
                                }
                            },
                            mods: {
                                disabled: data.exceed_limit_banners ? 'yes' : ''
                            },
                            type: 'submit',
                            content: mediaType === 'performance' || mediaType === 'mcbanner' ?
                                iget2('b-campaign-info', 'dobavit-gruppu-bannerov', 'Добавить группу баннеров') : iget2('b-campaign-info', 'dobavit-gruppu-obyavleniy', 'Добавить группу объявлений')
                        }
                    }
                ]
            },

            hasNewAddBannerButton && {
                elem: 'actions-bar-item',
                content: {
                    block: 'button',
                    mods: {
                        action: 'add-group-beta',
                        disabled: data.exceed_limit_banners ? 'yes' : ''
                    },
                    mix: [
                        {
                            block: 'b-campaign-info',
                            elem: 'virtual-campaign-button',
                        },
                        {
                            block: 'b-metrika2',
                            js: {
                                blockName: 'button',
                                event: 'click',
                                params: {
                                    showCamp: 'add-group'
                                }
                            }
                        },
                    ],
                    content: [
                        mediaType === 'performance' || mediaType === 'mcbanner' ?
                            iget2('b-campaign-info', 'dobavit-gruppu-bannerov', 'Добавить группу баннеров') :
                            iget2('b-campaign-info', 'dobavit-gruppu-obyavleniy', 'Добавить группу объявлений'),
                        !migration.oldEditDenied && { block: 'b-beta', mods: { type: 'symbol' } }
                    ]
                }
            },

            !!data.exceed_limit_banners && {
                elem: 'actions-bar-item',
                mix: [{
                    block: 'b-campaign-info',
                    elem: 'exceed-limit-help'
                }],
                content: {
                    block: 'dropdown',
                    content: [
                        {
                            block: 'icon',
                            mix: [
                                {
                                    block: 'dropdown',
                                    elem: 'switcher'
                                },
                                {
                                    block: 'b-campaign-info',
                                    elem: 'limit-banners-icon'
                                }
                            ],
                            mods: {
                                'size-13': 'question',
                                theme: 'light'
                            }
                        },
                        {
                            elem: 'popup',
                            elemMods: { theme: 'ffffff' },
                            js: {
                                tail: {
                                    offset: {
                                        left: 18
                                    }
                                }
                            },
                            content: data.exceed_limit_banners
                        }
                    ]
                }
            },
            actionsBar.canOptimizeCamp && {
                elem: 'actions-bar-item',
                content: {
                    block: 'b-campaign-optimize',
                    showComplete: this.ctx.showComplete
                }
            }
        ]
    };
});
