block('b-campaign-info')(

    elem('brief').content()(function() {
        var brief = this.ctx.brief,
            mediaType = this.ctx.mediaType;

        return brief.rows.map(function(cells) {
            return {
                elem: 'brief-row',
                content: cells.map(function(elemName) {
                    return {
                        elem: elemName,
                        brief: brief,
                        mediaType: mediaType
                    };
                })
            };
        });
    }),

    elem('start-date').wrap()(function() {
        return {
            elem: 'brief-item',
            label: iget2('b-campaign-info', 'nachalo', 'Начало') + ':',
            text: this.ctx.brief.startDate
        };
    }),

    elem('clicks').wrap()(function() {
        var text = this.ctx.brief.clicks || '&ndash;',
            mediaType = this.ctx.mediaType;

        if (u.campaign.isCpm(mediaType)) {
            text = u['b-campaign-info'].formatInt(text);
        }

        return {
            elem: 'brief-item',
            label: iget2('b-campaign-info', 'klikov', 'Кликов') + ':',
            text: text
        };
    }),

    elem('shows').wrap()(function() {
        var text = this.ctx.brief.shows || '&ndash;',
            mediaType = this.ctx.mediaType;

        if (u.campaign.isCpm(mediaType)) {
            text = u['b-campaign-info'].formatInt(text);
        }

        return {
            elem: 'brief-item',
            label: iget2('b-campaign-info', 'pokazov', 'Показов') + ':',
            text: text
        };
    }),

    elem('order').replace()(function() {
        return {
            elem: 'brief-item',
            label: '&#8470;&nbsp;' + iget2('b-campaign-info', 'zakaza', 'Заказа') + ':',
            text: this.data.cid
        };
    }),

    elem('till-date').wrap()(function() {
        return {
            elem: 'brief-item',
            label: iget2('b-campaign-info', 'predpolagaemaya-data-okonchaniya-kampanii', 'Предполагаемая дата окончания кампании') + ':',
            text: this.ctx.brief.tillDate
        };
    }),

    elem('money-for-display').wrap()(function() {
        return {
            elem: 'brief-item',
            label: iget2('b-campaign-info', 'oplacheno-pokazov-tys', 'Оплачено показов (тыс.)') + ':',
            text: u.formatShowsOrMoney(this.ctx.brief.sumUnits, 'shows')
        };
    }),

    elem('remained-money-for-display').wrap()(function() {
        return {
            elem: 'brief-item',
            label: iget2('b-campaign-info', 'ostalos-pokazov-tys', 'Осталось показов (тыс.)') + ':',
            text: u.formatShowsOrMoney(this.ctx.brief.totalUnits, 'shows')
        };
    }),

    elem('sum-block').replace()(function() {
        var data = this.data,
            brief = this.ctx.brief,
            currency = data.campaign.currency,
            canPay = !!(brief.canPay && data.allow_edit_camp && hasLoginRights('user_allow_pay'));

        return {
            elem: 'brief-item',
            label: iget2('b-campaign-info', 'summa', 'Сумма') + ':',
            text: [
                u.currencies.formatSum(currency, brief.sum, {
                    isPseudo: data.usePseudoCurrency
                }),
                '&nbsp;',
                currency != 'YND_FIXED' ?
                    {
                        block: 'b-help-link',
                        url: u.getHelpUrl('bonus')
                    } :
                    canPay && {
                        elem: 'pay-block',
                        sum: brief.sum
                    },
                {
                    elem: 'blocked-money',
                    blockedMoney: brief.blockedMoney,
                    blockedPayment: brief.blockedPayment,
                    cid: data.cid
                }
            ]
        };

    }),

    elem('rest-block').replace()(function() {
        var data = this.data,
            currency = data.campaign.currency,
            brief = this.ctx.brief,
            canPay = brief.canPay && data.allow_edit_camp && hasLoginRights('user_allow_pay');

        return {
            elem: 'brief-item',
            label: iget2('b-campaign-info', 'ostalos', 'Осталось') + ':',
            text: [
                u.currencies.formatSum(currency, brief.total, {
                    isPseudo: data.usePseudoCurrency
                }),
                currency == 'YND_FIXED' && '&nbsp;',
                currency == 'YND_FIXED' && {
                    elem: 'brief-item-grey',
                    content: [
                        '(',
                        u.currencies.convUnitExplanation(data.pay_currency),
                        ')'
                    ]
                },
                currency !== 'YND_FIXED' && '&nbsp;',
                currency !== 'YND_FIXED' && iget2('b-campaign-info', 'bez-nds', 'без НДС.'),
                currency !== 'YND_FIXED' && '&nbsp;',
                canPay != 0 && currency !== 'YND_FIXED' && {
                    elem: 'pay-block',
                    sum: brief.total
                },
                {
                    elem: 'blocked-money',
                    blockedMoney: brief.blockedMoney,
                    blockedPayment: brief.blockedPayment,
                    cid: data.cid
                }
            ]
        };
    }),

    elem('pay-block').def()(function() {
        var data = this.data,
            urlParams = {
                cid: +data.wallet_cid ? data.wallet_cid : data.campaign.cid,
                ulogin: data.user_login
            };

        return {
            block: 'link',
            mix: [{
                block: 'b-campaign-info',
                elem: 'pay-block'
            }],
            url: u.getUrl('pay', urlParams),
            content: +this.ctx.sum > 0 ? iget2('b-campaign-info', 'doplatit', 'доплатить') : iget2('b-campaign-info', 'oplatit', 'оплатить')
        };
    }),

    elem('brief-item').wrap()(function() {
        return [
            {
                elem: 'brief-item-label',
                attrs: this.ctx.wholeRow && {
                    colspan: 2
                },
                content: this.ctx.label,
                mix: this.ctx.labelMix
            },
            this.ctx.wholeRow ?
            '' :
                {
                    elem: 'brief-item-text',
                    content: this.ctx.text,
                    mix: this.ctx.textMix
                }
        ];
    })
);
