block('b-campaign-info').elem('details').content()(function() {

    var data = this.data,
        camp = data.campaign,
        daySum = camp.day_budget && +camp.day_budget.sum,
        currency = camp.currency,
        deals = camp.deals,
        isCPM = u.campaign.isCpm(camp.mediaType),
        isMCBanner = camp.mediaType === 'mcbanner',
        isNewCampaignStrategyEnabled = Boolean(data.is_new_campaign_strategy_enabled) && camp.mediaType !== 'cpm_deals',
        helpLinkId = 'selecting-strategy';

    isCPM && (helpLinkId = 'selecting-strategy-cpm-campaign');
    isMCBanner && (helpLinkId = 'selecting-strategy-search');

    return [
        (data.canBeVirtual === 1 || !!camp.is_virtual) && {
            elem: 'details-item',
            content: [
                {
                    elem: 'details-item-label',
                    content: [
                        iget2('b-campaign-info', 'virtual', 'Виртуальная'),
                        ':'
                    ]
                },
                {
                    elem: 'details-item-content',
                    content: camp.is_virtual ?
                        {
                            block: 'b-campaign-info',
                            elem: 'virtual-campaign-status',
                            content: iget2('b-campaign-info', 'set-virtual-status', 'да')
                        } :
                        {
                            block: 'button',
                            mods: { action: 'set-virtual' },
                            mix: [{
                                block: 'b-campaign-info',
                                elem: 'virtual-campaign-button',
                            }],
                            content: iget2('b-campaign-info', 'set-virtual', 'Сделать виртуальной')
                        }
                }
            ]
        },
        u.consts('failedToFetchMetrika') && {
            elem: 'details-item',
            content: {
                block: 'b-metrika-unavailable-warning',
                mix: [
                    { block: 'b-campaign-info', elem: 'metrika-unavailable-warning' }
                ]
            }
        },
        {
            elem: 'details-item',
            content: [
                {
                    elem: 'details-item-label',
                    content: [
                        iget2('b-campaign-info', 'strategiya', 'Стратегия'),
                        {
                            block: 'b-help-link',
                            mods: {
                                type: 'modal'
                            },
                            stretched: true,
                            url: u.getHelpUrl(helpLinkId)
                        }
                    ]
                },
                {
                    elem: 'details-item-content',
                    content: [
                        isNewCampaignStrategyEnabled && {
                            block: 'b-dna-strategy',
                            campaignId: data.campaign.cid,
                            strategyId: data.strategy_id
                        },
                        !isNewCampaignStrategyEnabled && {
                            block: 'b-campaign-strategy2',
                            mods: {
                                'with-ajax-save': 'yes',
                                'view-only': !hasLoginRights('superreader_control', 'limited_support_control') &&
                                    ( !this.data.allow_edit_camp ||
                                      hasLoginRights('media_control') ||
                                      this.data.archived === 'Yes') ? 'yes' : 'no',
                                'campaign-type': u.beminize(camp.mediaType),
                                'on-page': 'campaign'
                            },
                            ulogin: data.user_login,
                            script: data.SCRIPT,
                            campaignType: this.data.campaign.mediaType,
                            isNetStrategyEnabled: this.data.campaign.mediaType !== 'dynamic' ||
                                u.consts('rights').manageContextForDynamicCampaigns,
                            campDataModel: this.ctx.modelParams,
                            dayBudgetSettings: {
                                isEnabled: !!(this.data.client && this.data.client.can_use_day_budget ||
                                    +this.data.campaign.wallet_cid || +this.data.wallet_cid),
                                currency: this.data.campaign.currency,
                                maxDailyChangeCount: this.data.MAX_DAY_BUDGET_DAILY_CHANGE_COUNT
                            },
                            walletInfo: {
                                dayBudgetSettings: {
                                    sum: data.wallet_day_budget,
                                    showMode: data.wallet_day_budget_show_mode
                                },
                                url: u.getWalletLink(data.AgencyID)
                            },
                            isChangeManualStrategyName: Boolean(data.has_change_name_bid_optimization),
                            isSavedPeriodStrategyEditable: u.consts('isEditAvgCpmPeriodStrategyWithoutRestartEnabled'),
                            // Флаг о доступности стратегии,
                            // зависит от наличия каких-нибудь других кроме видео-групп в кампании
                            isCampaignsCpvStrategiesDisabled: !(+this.data.is_cpv_strategies_enabled)
                        },
                        camp.autobudget_warning && {
                            block: 'b-autobudget-warnings',
                            mods: {
                                'media-type': camp.mediaType
                            },
                            campaign: camp,
                            formattedCurrency: u.currencies.getName(camp.currency, {
                                isPseudo: data.usePseudoCurrency
                            })
                        },
                        {
                            block: 'b-low-conversions-warning',
                            mix: {
                                block: 'b-campaign-info',
                                elem: 'low-conversions-warning',
                                elemMods: {
                                    hidden: 'yes'
                                }
                            }
                        }
                    ]
                }
            ]
        },
        !!daySum && {
            elem: 'details-item',
            content: [
                {
                    elem: 'details-item-label',
                    content: iget2('b-campaign-info', 'dnevnoy-byudzhet', 'Дневной бюджет:')
                },
                {
                    elem: 'details-item-content',
                    content: [
                        u.currencies.formatSum(currency, daySum, {
                            isPseudo: data.usePseudoCurrency
                        }),
                        camp.spent_today < daySum && {
                            elem: 'details-item-info',
                            content: [
                                '&nbsp;',
                                '(',
                                iget2('b-campaign-info', 'spent', 'потрачено {sum}', {
                                    sum: u.currencies.formatSum(currency, data.spent_today)
                                }),
                                ')'

                            ]
                        },
                        {
                            elem: 'details-item-info',
                            content: [
                                ',&nbsp',
                                camp.day_budget.show_mode == 'default' ?
                                    iget2('b-campaign-info', 'standartnyy-rezhim-pokazov', 'стандартный режим показов') :
                                    iget2('b-campaign-info', 'raspredelyonnyy-rezhim-pokazov', 'распределённый режим показов')
                            ]
                        }
                    ]
                }
            ]
        },
        //@heliarian - для рекламы мобильных приложений нет мониторинга сайта
        //@belyanskii - для смартов нет мониторинга сайта DIRECT-51589
        //@aleks-konst - для продвижения контента нет мониторинга сайта DIRECT-95383
        !u._.contains(['mobile_content', 'performance', 'content_promotion'], camp.mediaType) && {
            elem: 'details-item',
            content: [
                {
                    elem: 'details-item-label',
                    content: [
                        iget2('b-campaign-info', 'monitoring-sayta', 'Мониторинг сайта'),
                        {
                            block: 'b-help-link',
                            mods: {
                                type: 'modal'
                            },
                            stretched: true,
                            url: u.getHelpUrl('availability-monitoring')
                        }
                    ]
                },
                {
                    elem: 'details-item-content',
                    content: data.statusMetricaControl == 'Yes' ?
                        data.global_status_metrica_stop ?
                            [
                                {
                                    elem: 'details-item-warn',
                                    content: camp.mediaType == 'mcbanner' ?
                                        iget2('b-campaign-info', 'v-kampanii-est-otklyuchennye', 'в кампании есть отключенные мониторингом сайтов баннеры') :
                                        iget2('b-campaign-info', 'v-kampanii-est-otklyuchennye-100', 'в кампании есть отключенные мониторингом сайтов объявления')
                                },
                                {
                                    block: 'b-metrika2',
                                    js: {
                                        immediate: {
                                            showCamp: {
                                                'metrika-site-monitoring': 'site-stopped'
                                            }
                                        }
                                    }
                                }
                            ] :
                        iget2('b-campaign-info', 'vklyuchen', 'включен') :
                        iget2('b-campaign-info', 'vyklyuchen', 'выключен')
                }
            ]
        },
        //@heliarian - для рекламы мобильных приложений нет мониторинга сайта
        //@belyanskii - для смартов нет мониторинга сайта DIRECT-51589
        //@aleks-konst - для продвижения контента нет мониторинга сайта DIRECT-95383
        camp.brand_survey_id && {
            elem: 'details-item',
            elemMods: {
                'content-brand-lift': 'yes'
            },
            content: [
                {
                    elem: 'details-item-label',
                    content: [
                        iget2(
                            'b-campaign-info',
                            'brand-lift',
                            'Brand Lift'
                        ),
                        {
                            block: 'b-beta',
                            mods: { type: 'symbol' }
                        },
                        {
                            block: 'b-help-link',
                            mods: { type: 'modal' },
                            stretched: true,
                            url: u.getHelpUrl('brand-lift')
                        }
                    ]
                },
                {
                    elem: 'details-item-content',
                    content: {
                        block: 'brand-lift-control',
                        modelParams: {
                            name: camp.mediaType === 'cpm_banner' ?
                                'dm-cpm-banner-campaign' :
                                'dm-cpm-yndx-frontpage-campaign',
                            id: camp.cid
                        },
                        brandSurveyId: camp.brand_survey_id,
                        clientId: camp.ClientID || data.ClientID,
                        currency: camp.currency
                    }
                }
            ]
        },
        camp.mediaType === 'cpm_deals' && {
            elem: 'details-item',
            content: [
                {
                    elem: 'details-item-label',
                    content: [
                        iget2('b-campaign-info', 'deals', 'Сделки'),
                        {
                            block: 'b-help-link',
                            mods: { type: 'modal' },
                            stretched: true,
                            url: u.getHelpUrl('deals')
                        }
                    ]
                },
                {
                    elem: 'details-item-content',
                    content: {
                        block: 'b-campaign-deals',
                        mods: {
                            readonly: hasEnabledFeatures('cpm_deals') && hasLoginRights('agency_control',
                                'support_control','limited_support_control', 'placer_control') || hasLoginRights('super_control') ?
                                    '' :
                                    'yes',
                            disabled: camp.can_update_deals ? '' : 'yes'
                        },
                        value: u._.filter(deals, function(deal) {
                            return deal.direct_deal_status === 'Active';
                        }),
                        agencyLogin: u._.get(data, 'agency_info.login'),
                        cid: camp.cid
                    }
                }
            ]
        }
    ];
});
