block('b-campaign-info').elem('header').replace()(function() {

    var data = this.data,
        header = this.ctx.header,
        isStatPage = this.ctx.isStatPage,
        ulogin = data.user_login,
        title = header.cname ?
        '&laquo;' + u.escapeHTML(header.cname) + '&raquo; ' + iget2('b-campaign-info', 'no', '№') + '&nbsp;' + header.cid :
        '',
        cleanForm = this.data.FORM,
        hasWallet = data.wallet_is_enabled == '1';

    delete cleanForm['uid_url'];

    return {
        block: 'b-page-title',
        mix: [{
            block: 'b-campaign-info',
            elem: 'header'
        }],
        title: [
            {
                block: 'b-campaign-info',
                elem: 'header-headword',
                content: header.headword + ' '
            },
            (header.campsList || []).length ?
                {
                    block: 'dropdown',
                    content: [
                        {
                            mix: [{
                                block: 'dropdown',
                                elem: 'switcher'
                            }],
                            block: 'link',
                            mods: {
                                pseudo: 'yes'
                            },
                            content: [
                                title,
                                {
                                    block: 'b-campaign-info',
                                    elem: 'header-arrow'
                                }
                            ]
                        },
                        {
                            elem: 'popup',
                            mix: [{
                                block: 'b-campaign-info',
                                elem: 'header-popup'
                            }],
                            js: {
                                directions: 'bottom-left'
                            },
                            elemMods: { adaptive: 'no' },
                            content: {
                                block: 'b-campaign-info',
                                elem: 'header-popup-content',
                                elemMods: {
                                    'has-icons': header.campsList.filter(function(c) {
                                        return c.mediaType == 'mobile_content';
                                    }).length > 0 ?
                                    'yes' : ''
                                },
                                content: [
                                    hasWallet && {
                                        elem: 'wallet-notice',
                                        content: iget2(
                                            'b-campaign-info',
                                            'dlya-kampaniy-podklyuchennyh-k',
                                            'Для кампаний, подключенных к общему счёту, в качестве остатка отображается остаток по общему счёту.'
                                        )
                                    },
                                    {
                                        elem: 'list-campaigns',

                                        content: header.campsList.map(function(c) {
                                            var form = u._.omit(data.FORM);

                                            var link = [
                                                {
                                                    block: 'link',
                                                    js: true,
                                                    mix: [
                                                        {
                                                            block: 'b-campaign-info',
                                                            elem: c.mediaType !== 'mobile_content' ?
                                                                'default-camp-text' :
                                                                'mobile-content-camp-text'
                                                        },
                                                        {
                                                            block: 'b-metrika2',
                                                            js: {
                                                                nativeEvent: 'click',
                                                                params: {
                                                                    showCamp: {
                                                                        'campaigns-list': 'navigate'
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    ],
                                                    url: isStatPage ?
                                                    u.formatUrl({
                                                        host: data.SCRIPT,
                                                        query: u._.extend(
                                                            // при переключении на другую кампанию нужно вычищать
                                                            // значения фильтров полей ввода мастера отчетов
                                                            u._.omit(form, [
                                                                'goals',
                                                                'tag',
                                                                'filter_tag',
                                                                'filter_adgroup',
                                                                'filter_banner',
                                                                'filter_page',
                                                                'filter_phrase',
                                                                'filter_retargeting',
                                                                'filter_geo'
                                                            ]), {
                                                                cid: c.cid
                                                            })
                                                    }) : u.getUrl('showCamp', {
                                                        cid: c.cid,
                                                        ulogin: ulogin
                                                    }),

                                                    content: [
                                                        u.hellipCut(u.escapeHTML(c.name), 30),
                                                        c.cid
                                                    ].join('&nbsp;№&nbsp;')
                                                },
                                                ' (' + c.total + ')'
                                            ];

                                            return {
                                                elem: 'list-campaigns-item',
                                                content: c.mediaType == 'mobile_content' ?
                                                    {
                                                        block: 'b-icon-text',
                                                        icon: {
                                                            'size-16': 'mobile-content'
                                                        },
                                                        content: link
                                                    } :
                                                    link
                                            };
                                        })
                                    },
                                    header.allCampsUrl && {
                                        elem: 'all-campaigns',
                                        content: {
                                            block: 'link',
                                            url: header.allCampsUrl,
                                            content: iget2('b-campaign-info', 'vse-kampanii-klienta', 'Все кампании клиента')
                                        }
                                    }
                                ]
                            }
                        }
                    ]
                } :
                title
        ],
        text: [
            header.text, {
                block: 'b-campaign-type',
                mediaType: (this.data.campaign || {}).mediaType
            }
        ]
    };
});
