block('b-campaign-info').elem('menu').content()(function() {
    var data = this.data,
        menu = this.ctx.menu || {},
        pm = data.login_rights,
        experiment = data.experiments && data.experiments[data.campaign.experiment_id],
        items = [],
        result;

    hasLoginRights('super_control', 'superreader_control', 'limited_support_control', 'AdmSendBKMD') && data.OrderID != 0 &&
        items.push({
            text: iget2('b-campaign-info', 'bk', 'БК:') + '&nbsp;' + data.OrderID,
            url: u.formatUrl({
                host: 'https://lookup-profile-caesar1.n.yandex-team.ru',
                path: 'lookup_profile/Orders',
                query: {
                    OrderID: data.OrderID
                }
            })
        });

    data.statusModerate != 'New' && !hasLoginRights('is_any_client', 'agency_control') &&
        items.push({
            text: iget2('b-campaign-info', 'moderaciya', 'Модерация'),
            url: u.moderation.getCampaignModerationUrl(data.is_production, data.campaign.cid)
        });

    (pm.is_internal_user || hasLoginRights('limited_support_control')) &&
        items.push({
            text: iget2('b-campaign-info', 'dokumenty', 'Документы'),
            url: u.moderation.getCampaignDocumentsUrl(data.is_production, data.ClientID)
        });

    if (hasLoginRights('AdmSendBKMD', 'AdmSendBalance')) {
        if (data.sum > 0) {
            items.push({
                text: iget2('b-campaign-info', 'billing', 'Биллинг'),
                url: u.formatUrl({
                    host: u.consts('balance_admin'),
                    path: 'order.xml',
                    query: {
                        service_cc: menu.ccService || 'PPC',
                        service_order_id: data.campaign.cid
                    }
                })
            });
        } else if (hasLoginRights('AdmSendBalance')) {
            items.push({
                text: iget2('b-campaign-info', 'billing', 'Биллинг'),
                url: u.getUrl('admSendBalance', {
                    cid: data.campaign.cid,
                    ulogin: data.user_login
                })
            });
        }
    }

    hasLoginRights(
            'super_control', 'support_control', 'limited_support_control', 'superreader_control',
            'is_superteamleader', 'is_teamleader', 'manager_control') &&
        items.push({
            text: iget2('b-campaign-info', 'logi', 'Логи'),
            url: u.getUrl('showLogs', {
                cid: data.campaign.cid,
                date_from: data.date_today,
                date_to: data.date_today,
                type: 'cmd'
            })
        });

    hasLoginRights('super_control', 'support_control', 'limited_support_control', 'superreader_control', 'manager_control') &&
        items.push({
            text: iget2('b-campaign-info', 'pisma', 'Письма'),
            url: u.getUrl('showMailLogs', {
                cid: data.campaign.cid,
                search_query: data.user_login
            })
        });

    data.is_beta && hasLoginRights('super_control', 'is_developer') &&
        items.push({
            text: iget2('b-campaign-info', 'modifikaciya-nbsp-bd', 'Модификация&nbsp;БД'),
            url: u.getUrl('fakeadmCamp', {
                cid: data.campaign.cid
            })
        });

    hasLoginRights(
            'manager_control',
            'is_super_placer',
            'media_control',
            'support_control',
            'limited_support_control',
            'superreader_control',
            'super_control') &&
        items.push({
            text: iget2('b-campaign-info', 'prosmotr-nbsp-izmeneniy', 'Просмотр&nbsp;изменений'),
            url: u.getUrl('showManagerLogs', {
                cid: data.campaign.cid,
                type: 'cmd'
            })
        });

    hasLoginRights('is_internal_user', 'limited_support_control') &&
        items.push({
            text: iget2('b-campaign-info', 'crm', 'CRM'),
            url: u.formatUrl({
                host: 'https://crm.yandex-team.ru',
                path: 'client.aspx',
                query: {
                    id: data.campaign.ClientID || data.ClientID
                }
            })
        });

//    Сервис otrs.yandex-team.ru почил, засим закоменчено
//    hasLoginRights('super_control', 'support_control', 'limited_support_control') && items.push({
//        text: iget2('b-campaign-info', 'tickets', 'Tickets'),
//        url: u.formatUrl({
//            host: 'http://otrs.yandex-team.ru',
//            path: 'search',
//            query: {
//                X_OTRS_Login: (data.uid_par && data.uid_par.value) || data.uname || data.user_login, //todo login func
//                QueueID: '2475_2492*_2311_2804*'
//            }
//        })
//    });

    result = items.map(function(i) {

        return {
            block: 'link',
            mix: [{
                block: 'b-campaign-info',
                elem: 'menu-item'
            }],
            target: '_blank',
            url: i.url,
            content: i.text
        };
    });

    experiment && result.push({
        block: 'b-experiment-mark',
        experiment: experiment,
        hasActions: hasLoginRights('super_control', 'manager_control')
    }, {
        block: 'b-metrika2',
        js: {
            immediate: {
                showCamp: {
                    experiment: 'show'
                }
            }
        }
    });

    return result;
});
