block('b-campaign-info')(
    def()(function() {
        this.ctx.modelParams = this.ctx.modelParams || {
            name: 'm-campaign',
            id: this.data.campaign.cid
        };

        return applyNext();
    }),

    js()(function() {
        var campaign = this.data.campaign || {};
        var strategyName = (campaign.strategy2 || {}).name || '';

        return {
            login: this.data.user_login,
            cid: campaign.cid,
            mediaType: campaign.mediaType,
            isCpaPayForConversionEnabled: campaign.isCpaPayForConversionEnabled,
            modelParams: this.ctx.modelParams,
            selectedMobileApp: campaign.selected_mobile_app,
            isArchived: campaign.archived === 'Yes',
            strategyName: strategyName,
            isSkadNetworkEnabled: campaign.is_skadnetwork_enabled,
            isNewIosVersionEnabled: campaign.is_new_ios_version_enabled
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            hasMenu = !!((this.data.allow_edit_camp || this.data.campaign.allow_edit_camp) &&
                !hasLoginRights('media_control') ||
                hasLoginRights('superreader_control', 'AdmSendBKMD', 'media_control', 'limited_support_control')),
            showOriginalSumDebugInfo = this.data.FORM.debug &&
            hasLoginRights('support_control', 'limited_support_control', 'is_developer', 'super_control'),
            currency = this.data.campaign.currency,
            yaDomain = this.data.yandex_domain;

        return [
            {
                elem: 'header',
                header: ctx.header,
                isStatPage: this.ctx.isStatPage,
                mods: ctx.header.mods ? ctx.header.mods : ''
            },
            {
                elem: 'content',
                content: [
                    {
                        elem: 'data',
                        content: [
                            !ctx.showOptToolbox || {
                                elem: 'optimize-ready'
                            },
                            !ctx.brief || {
                                elem: 'brief',
                                brief: ctx.brief,
                                mediaType: this.data.mediaType
                            },
                            !showOriginalSumDebugInfo || {
                                elem: 'original-sum-info',
                                content: 'original_sum_spent: ' + this.data.original_sum_spent +
                                    ', original_sum: ' + this.data.original_sum
                            },
                            !hasMenu || {
                                elem: 'menu',
                                menu: ctx.menu
                            },
                            !ctx.details || {
                                elem: 'details',
                                modelParams: this.ctx.modelParams
                            }
                        ]
                    },
                    ctx.state && {
                        elem: 'state',
                        content: [
                            {
                                block: 'b-campaign-state',
                                mods: ctx.state.mods ? ctx.state.mods : '',
                                statusText: ctx.state.text,
                                needClientInfo: ctx.state.needClientInfo,
                                lowConversionsWarning: !ctx.details,
                            },
                            {
                                block: 'b-ya-surveys-teaser'
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'lack-of-funds-warning',
                elemMods: {
                    hidden: 'yes'
                },
                content: {
                    block: 'b-warning-message',
                    theme: 'red',
                    content: {
                        block: this.block,
                        elem: 'lack-of-funds-warning-content',
                        content: [
                            {
                                content: [
                                    {
                                        block: 'icon',
                                        mods: {
                                            'size-16': 'alert'
                                        },
                                        mix: {
                                            block: this.block,
                                            elem: 'lack-of-funds-warning-icon'
                                        }
                                    },
                                    iget2('b-campaign-info', 'lack-of-funds-2', 'Для работы по модели оплаты за конверсии на общем счёте должно быть не менее {emphasizedStr} и не менее {minBalanceAmount}&nbsp;{minBalanceCurrency}, где {emphasizedStr2} - максимальное значение между значением цены конверсии на кампании и на фильтрах.', {
                                        emphasizedStr: {
                                            tag: 'strong',
                                            content: iget2('b-campaign-info', 'min-fund-balance-for-cpa', '{numOfConversions} × Цена конверсии', {
                                                numOfConversions: u.consts('PAY_FOR_CONVERSION_AVG_CPA_WARNING_RATIO_DEFAULT_VALUE')
                                            })
                                        },
                                        minBalanceAmount: u.currencies.getConst(currency, 'PAY_FOR_CONVERSION_MIN_RESERVED_SUM_DEFAULT_VALUE'),
                                        minBalanceCurrency: u.currencies.get(currency).currency_sign,
                                        emphasizedStr2: {
                                            tag: 'strong',
                                            content: iget2('b-campaign-info', 'balance-for-cpa', 'Цена конверсии')
                                        },
                                    })
                                ]
                            },
                            {
                                block: 'button2',
                                mods: {
                                    theme: 'pseudo',
                                    type: 'link',
                                    size: 's',
                                },
                                mix: {
                                    block: this.block,
                                    elem: 'lack-of-funds-warning-button'
                                },
                                text: iget2('b-campaign-info', 'lack-of-funds-help', 'Подробнее'),
                                url: u.getCommonHelpUrl('/direct/strategies/average-cpa.html#average-cpa__conversions-specs'),
                                target: '_blank'
                            }
                        ]
                    }
                }
            },
            {
                elem: 'impressions-limiting-on-ios-warning',
                elemMods: {
                    hidden: 'yes'
                },
                content: {
                    block: 'b-warning-message',
                    mods: { theme: 'info' },
                    icon: {
                        block: 'icon',
                        mods: { 'size-12': 'info' },
                        mix: {
                            block: this.block,
                            elem: 'impressions-limiting-on-ios-warning-icon'
                        }
                    },
                    content: {
                        block: this.block,
                        elem: 'impressions-limiting-on-ios-warning-content',
                        content: [
                            {
                                block: this.block,
                                elem: 'impressions-limiting-on-ios-warning-content-wrapper',
                                content: [
                                    {
                                        block: this.block,
                                        elem: 'impressions-limiting-on-ios-warning-title',
                                        content: iget2('b-campaign-info', 'impressions-limiting-on-ios-text', 'Временно ограничены показы для пользователей с версией iOS 14.5 и выше. {helpLink}', {
                                            helpLink: function(text) {
                                                return {
                                                    block: 'link',
                                                    url: '//' + yaDomain + '/support/direct/products-mobile-apps-ads/ios.html',
                                                    target: '_blank',
                                                    content: text
                                                };
                                            }(iget2('b-campaign-info', 'impressions-limiting-on-ios-more', 'Подробнее')),
                                        })
                                    },
                                ],
                            },
                            {
                                block: 'button',
                                mix: {
                                    block: this.block,
                                    elem: 'impressions-limiting-on-ios-warning-close-button'
                                },
                                mods: {
                                    theme: 'plain',
                                },
                                content: {
                                    block: 'icon',
                                    mods: { 'size-12': 'clear' }
                                }
                            }
                        ]
                    }
                }
            },
            !ctx.actionsBar || {
                elem: 'actions-bar',
                migration: ctx.migration,
                actionsBar: ctx.actionsBar
            }
        ];
    }),

    elem('blocked-money').match(function() {
        return !this._blockedMoney;
    }).def()(function() {
        var ctx = this.ctx,
            cid = ctx.cid,
            balanceHost = u.consts('balance'),
            blockedMoney = ctx.blockedMoney,
            blockedPayment = ctx.blockedPayment &&
            hasLoginRights(
                'super_control', 'support_control', 'limited_support_control', 'manager_control', 'placer_control', 'media_control');

        // Предупреждение должно выводиться 1 раз (в блоке "Сумма" или в блоке "Осталось", если "Сумма" отсутствует)
        this._blockedMoney = blockedMoney || blockedPayment;

        return this._blockedMoney && [
            {
                block: 'icon-text',
                mods: { size: 'ms', theme: 'alert' },
                text: {
                    block: 'b-campaign-info',
                    elem: 'brief-item-warn',
                    content: !blockedMoney ?
                        iget2('b-campaign-info', 'oplata-zapreshchena', 'Оплата запрещена') :
                        iget2('b-campaign-info', 'vnimanie-na-kampanii-est', 'Внимание! На кампании есть {link}!', {
                            link: function(text) {
                                return {
                                    block: 'link',
                                    url: u.formatUrl({
                                        host: balanceHost,
                                        path: 'order.xml',
                                        query: {
                                            service_cc: 'PPC',
                                            service_order_id: cid
                                        }
                                    }),
                                    content: text
                                };
                            }(iget2('b-campaign-info', 'vnimanie-na-kampanii-est-param-link', 'заблокированные средства')),

                            context: 'link - заблокированные средства'
                        })

                }
            },
            {
                block: 'b-metrika2',
                js: {
                    immediate: {
                        showCamp: {
                            'blocked-money': 'show'
                        }
                    }
                }
            }
        ];
    })

);
