BEM.DOM.decl('b-campaign-info', {

    onSetMod: {
        js: function() {
            BEM.blocks['brand-lift-control'].on(this.domElem, 'delete', this._hideBrandLiftDetails, this);
            BEM.blocks['link'].on(this.domElem, 'click', this._hideOptimizeReport, this);
            BEM.blocks['button'].on(this.domElem, 'click', this._handleActionButtonClick, this);
            BEM.blocks['dropdown'].on(this.domElem, 'show', this._sendMetrikaParams, this);

            this._hideWarningButton = this.findBlockInside('impressions-limiting-on-ios-warning-close-button', 'button');
            if (this._hideWarningButton) {
                this._hideWarningButton.on('click', this._hideWarning, this);
            }

            this._updatePayForConversionInfo();
            this._updateImpressionsLimitingOnIOS();
        }
    },

    _storageItemNameImpressionsLimitingWarningHidden: 'direct:storageImpressionsLimitingWarningHidden',

    _hideOptimizeReport: function() {
        var p = this.params;

        this._getRequest().get(
            {
                cmd: 'ajaxPostponeOptimize',
                cid: p.cid,
                optimize_request_id: p.optimizeRequestId
            },
            function() {}
        );

        this.elem('optimize-ready').hide();
    },

    _setCampVirtualStatus: function() {
        var p = this.params,
            confirm = BEM.blocks['b-confirm'],
            button = this.findBlockInside('virtual-campaign-button', 'button');

        confirm.open({
            message: iget2('b-campaign-info', 'set-virtual-confirm', 'После применения, атрибут "Виртуальная" нельзя будет изменить. Продолжить?'),
            onYes: function() {
                var errorText = iget2('b-campaign-info', 'set-virtual-error', 'При сохранении атрибута кампании "Виртуальная" произошла ошибка')

                button.setMod('disabled', 'yes');

                this._getRequest().get(
                    {
                        cmd: 'ajaxSaveIsVirtual',
                        cid: p.cid,
                        ulogin: p.ulogin,
                        is_virtual: 1
                    },
                    function(response) {
                        if (response.success) {
                            BEM.DOM.replace(this.findElem('virtual-campaign-button'), BEMHTML.apply({
                                block: 'b-campaign-info',
                                elem: 'virtual-campaign-status',
                                content: iget2('b-campaign-info', 'set-virtual-status', 'да')
                            }));

                            confirm.alert(iget2('b-campaign-info', 'set-virtual-ok', 'Атрибут кампании "Виртуальная" успешно сохранён'));
                        } else if (response.error) {
                            confirm.alert(errorText);
                        }
                    },
                    function() {
                        confirm.alert(errorText);
                    }
                );
            }
        }, this);

    },

    _getRequest: function() {
        return this._request || (this._request = BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            dataType: 'json',
            cache: false,
            callbackCtx: this
        }));
    },

    _addGroup: function() {
        var dna = window.dna;
        if (dna === undefined) {
            throw new Error('dna is not defined');
        }

        var button = this.findBlockInside({ block: 'button', modName: 'action', modVal: 'add-group-beta' });
        button.setMod('disabled', 'yes');

        window.location = u.getEditGroupInNewInterfaceUrl(true, {
            ulogin: this.params.login,
            cid: this.params.cid
        });
    },

    _hideBrandLiftDetails: function() {
        this.elem('details-item', 'content-brand-lift', 'yes')[0].remove()
    },

    _onSendToModerateCampaignWithSurvey: function(button) {
        var campaignModel = BEM.MODEL.getOne(this.params.modelParams),
            surveyStatus = campaignModel.get('brand_survey_state'),
            form = button.domElem.closest('form');

        if (surveyStatus === 'unfeasible') {
            BEM.blocks['b-confirm'].open({
                message: {
                    content: iget2('b-campaign-info',
                        'do-you-want-to-start-campaign-without-brandlift',
                        'Не выполнены {brandLiftConditions}. Запустить кампанию без Brand Lift?',
                        {
                            brandLiftConditions: {
                                block: 'link',
                                url: u.getCommonHelpUrl('direct/brand-lift.html'),
                                target: '_blank',
                                content: iget2(
                                    'b-campaign-info',
                                    'brandlift-conditions',
                                    'условия для проведения Brand Lift'
                                )
                            }
                        }
                    )
                },
                onYes: function() {
                    form.submit();
                }.bind(this)
            });
        } else {
            form.submit();
        }
    },

    _handleActionButtonClick: function(e) {
        var buttonModValAction = e.block.getMod('action');

        if (buttonModValAction === 'set-virtual') {
            this._setCampVirtualStatus();
        } else if (buttonModValAction === 'add-group-beta') {
            this._addGroup();
        } else if (buttonModValAction === 'send-to-moderate-campaign-with-survey') {
            this._onSendToModerateCampaignWithSurvey(e.block);
        }
    },

    _sendMetrikaParams: function() {
        BEM.blocks['b-metrika2'].params({
            params: {
                showCamp: {
                    'campaigns-list': 'show'
                }
            }
        });
    },

    _updatePayForConversionInfo: function() {
        var dna = window.dna,
            login = this.params.login,
            campaignId = this.params.cid,
            mediaType = this.params.mediaType,
            isSkadNetworkEnabled = this.params.isSkadNetworkEnabled,
            isCpaPayForConversionEnabled = this.params.isCpaPayForConversionEnabled,
            availableCampaignTypes = ['text', 'performance', 'dynamic', 'mobile_content'];

        if (!dna || !dna.utils || !dna.utils.getQueryExecutor) {
            throw new Error('An error has occurred in loading DNA dependencies');
        }

        var queryExecutor = dna.utils.getQueryExecutor(login);

        if (!u._.includes(availableCampaignTypes, mediaType)) {
            return;
        }

        if (isCpaPayForConversionEnabled != 1) {
            return;
        }

        queryExecutor.getPayForConversionInfo(login, campaignId)
            .then(function(payForConversionInfo) {
                if (payForConversionInfo.lackOfConversions) {
                    this.delMod(this.findElem('low-conversions-warning'), 'hidden')
                }

                if (payForConversionInfo.lackOfFunds) {
                    this.delMod(this.findElem('lack-of-funds-warning'), 'hidden')
                }
            }.bind(this))
            .catch(function() {
                // ничего не делаем
            });
    },

    _updateImpressionsLimitingOnIOS: function() {
        var isRMP = this.params.mediaType === 'mobile_content',
            isIOS = this.params.selectedMobileApp ? this.params.selectedMobileApp.mobileContent.os_type === 'iOS' : false,
            isHiddenByUser = false;

        try {
            isHiddenByUser = window.localStorage.getItem(
                this._storageItemNameImpressionsLimitingWarningHidden
            ) || false;
        } catch (error) {}

        if (
            isRMP &&
            isIOS &&
            !isHiddenByUser &&
            !this.params.isSkadNetworkEnabled &&
            !this.params.isNewIosVersionEnabled &&
            !this.params.isArchived
        ) {
            this.delMod(this.findElem('impressions-limiting-on-ios-warning'), 'hidden');
        }
    },

    _hideWarning: function() {
        this.setMod(this.findElem('impressions-limiting-on-ios-warning'), 'hidden', 'yes');

        try {
            window.localStorage.setItem(this._storageItemNameImpressionsLimitingWarningHidden, 'true');
        } catch (error) {}
    },

    destruct: function() {
        BEM.blocks['brand-lift-control'].un(this.domElem, 'delete', this._hideBrandLiftDetails, this);
        BEM.blocks['link'].un(this.domElem, 'click', this._hideOptimizeReport, this);
        BEM.blocks['button'].un(this.domElem, 'click', this._handleActionButtonClick, this);
        BEM.blocks['dropdown'].un(this.domElem, 'show', this._sendMetrikaParams, this);

        if (this._hideWarningButton) {
            this._hideWarningButton.un('click', this._hideWarning, this);
        }
    }

});
