block('b-campaign-menu').elem('banner-actions').elemMod('type', 'mobile-content-camp').content()(function() {
    var data = this.data,
        opt = this.options,
        items = [];

    if (data.banners && data.banners.length > 0) {
        if (!opt.campIsArch) {
            !opt.campOptionsViewOnly && data.autobudget != 'Yes' &&
                items.push({
                    elem: 'item',
                    content: {
                        block: 'b-offline-set-phrases-prices',
                        js: {
                            modelName: this.ctx.modelParams.name
                        },
                        currency: data.campaign.currency,
                        content: [
                            {
                                elem: 'popup',
                                directions: [
                                    {
                                        to: 'left',
                                        axis: 'top',
                                        offset: {
                                            bottom: 60
                                        },
                                        tail: {
                                            axis: 'center'
                                        }
                                    },
                                    'bottom-left-center'
                                ]
                            },
                            {
                                block: 'link',
                                mods: {
                                    pseudo: 'yes',
                                    theme: 'dark-blue'
                                },
                                mix: [{
                                    block: 'b-offline-set-phrases-prices',
                                    elem: 'toggle',
                                    js: {
                                        modelParams: this.ctx.modelParams
                                    }
                                }],
                                content: iget2('b-campaign-menu', 'bids-for-all-campaign', 'Ставки для всей кампании')
                            }
                        ]

                    }
                });

            if (!data.campaign.readonly) {
                items.push({
                    elem: 'item',
                    content: {
                        block: 'b-minus-words-control',
                        switcherType: 'link',
                        switcherMods: {
                            theme: 'dark-blue'
                        },
                        modelParams: this.ctx.modelParams,
                        requestParams: {
                            for: 'campaign',
                            cid: data.campaign.cid,
                            ulogin: data.FORM.ulogin,
                            onSuccessSave: 1
                        },
                        for: 'campaign',
                        switcherText: iget2('b-campaign-menu', 'edinyy-nabor-minus-fraz', 'Единый набор минус-фраз'),
                        minusWords: data.minus_words
                    }
                });

                if ( u.consts('isMassEditRegionsInDnaEnabled')) {
                    items.push({
                        elem: 'item',
                        content: [
                            {
                                block: 'link',
                                mods: {
                                    pseudo: 'yes',
                                    theme: 'dark-blue'
                                },
                                mix: [{
                                    block: 'b-campaign-menu',
                                    elem: 'change-geo'
                                }],
                                content: iget2('b-campaign-menu', 'geo', 'Настроить регионы показа')
                            }
                        ]
                    });
                }
            }
        }

        items.push({
            elem: 'item',
            elemMods: {
                mode: 'dropdown',
                for: 'search'
            },
            text: iget2('b-campaign-menu', 'poisk-po-kampanii', 'Поиск по кампании'),
            popupMix: {
                block: 'b-simple-dropdown',
                elem: 'popup',
                elemMods: { padding: 'no' }
            },
            popupJs: {
                directions: [
                    {
                        to: 'left',
                        axis: 'middle',
                        tail: 'middle',
                        offset: {
                            bottom: -40
                        }
                    },
                    'bottom-left-center'
                ]
            },
            content: {
                block: 'b-banners-search'
            }
        });

        data.tags_allowed == 'Yes' &&
            items.push({
                elem: 'item',
                elemMods: {
                    mode: 'dropdown',
                    for: 'tags'
                },
                text: iget2('b-campaign-menu', 'metki', 'Метки'),
                popupJs: {
                    directions: [
                        {
                            to: 'left',
                            axis: 'middle',
                            tail: 'middle',
                            offset: {
                                bottom: -20
                            }
                        },
                        'bottom-left-center'
                    ]
                },
                content: {
                    block: 'b-campaign-tags',
                    modelParams: this.ctx.modelParams,
                    js: {
                        readonly: opt.readonly
                    },
                    cid: data.campaign.cid
                }
            });
    }

    return items;
});
