block('b-campaign-menu').elem('banner-actions').content()(function() {
    var data = this.data,
        pm = data.login_rights,
        opt = this.options,
        items = [],
        mediaType = data.campaign.mediaType,
        isSmartCampaign = mediaType === 'performance',
        isDynamicCampaign = mediaType === 'dynamic',
        isMcbanner = mediaType === 'mcbanner',
        isContentPromotion = mediaType === 'content_promotion',
        isCpmBannerCampaign = u.campaign.isCpm(mediaType),
        isCampaignEnabledInDnaGrid = !['cpm_deals', 'cpm_yndx_frontpage'].includes(mediaType);

    if (data.banners && data.banners.length > 0) {
        !isSmartCampaign && !isDynamicCampaign && !isMcbanner && !isContentPromotion && !isCpmBannerCampaign &&
        pm.is_internal_user && pm.role !== 'superreader' &&
            !opt.campIsArch && items.push({
                elem: 'item',
                elemMods: {
                    mode: 'dropdown',
                    for: 'mediaplan'
                },
                text: iget2('b-campaign-menu', 'skopirovat-obyavleniya-br-v', 'Скопировать объявления<br>в медиаплан'),
                popupJs: {
                    directions: [
                        {
                            to: 'left',
                            axis: 'middle',
                            tail: 'middle',
                            offset: {
                                bottom: -60
                            }
                        },
                        'bottom-left-center'
                    ]
                },
                content: {
                    block: 'b-banners-to-media'
                }
            });

        if (!opt.campIsArch) {
            !opt.campOptionsViewOnly &&
                (/^(autobudget_avg_cpc|autobudget_avg_cpa)_per_(camp|filter)$/
                    .test(this.data.campaign.strategy.net.name) || data.autobudget != 'Yes') && items.push({
                        elem: 'item',
                        content: {
                            block: 'b-offline-set-phrases-prices',
                            mods: {
                                type: isDynamicCampaign ?
                                    'dynamic-groups' :
                                    u.beminize(data.campaign.mediaType)
                            },
                            currency: data.campaign.currency,
                            content: [
                                {
                                    elem: 'popup',
                                    elemMods: {
                                        type: isDynamicCampaign ?
                                            'dynamic-groups' :
                                            u.beminize(data.campaign.mediaType)
                                    },
                                    directions: [
                                        {
                                            to: 'left',
                                            axis: 'top',
                                            offset: {
                                                bottom: 60
                                            },
                                            tail: {
                                                axis: 'center'
                                            }
                                        },
                                        'bottom-left-center'
                                    ]
                                },
                                {
                                    block: 'link',
                                    mods: {
                                        pseudo: 'yes',
                                        theme: 'dark-blue'
                                    },
                                    mix: [{
                                        block: 'b-offline-set-phrases-prices',
                                        elem: 'toggle',
                                        js: {
                                            modelParams: this.ctx.modelParams
                                        }
                                    }],
                                    content: iget2('b-campaign-menu', 'bids-for-all-campaign', 'Ставки для всей кампании')
                                }
                            ]

                        }
                    });

            var renderMinusWordsControl =
                !isCpmBannerCampaign &&
                !isSmartCampaign &&
                (!data.campaign.readonly || hasLoginRights('superreader_control', 'limited_support_control'));

            if (renderMinusWordsControl) {
                items.push({
                    elem: 'item',
                    content: {
                        block: 'b-minus-words-control',
                        js: {
                            metrikaGoal: {
                                onShow: {
                                    name: 'ShowCamp.Common_negative_keywords.popup'
                                },
                                onSave: {
                                    name: 'ShowCamp.Common_negative_keywords.popup.save'
                                }
                            }
                        },
                        switcherType: 'link',
                        switcherMods: {
                            theme: 'dark-blue'
                        },
                        modelParams: this.ctx.modelParams,
                        requestParams: {
                            for: 'campaign',
                            cid: data.campaign.cid,
                            ulogin: data.FORM.ulogin,
                            onSuccessSave: 1
                        },
                        for: 'campaign',
                        switcherText: iget2('b-campaign-menu', 'edinyy-nabor-minus-fraz', 'Единый набор минус-фраз'),
                        minusWords: data.minus_words
                    }
                });
            }

            if (!data.campaign.readonly && u.consts('isMassEditRegionsInDnaEnabled') && isCampaignEnabledInDnaGrid) {
                items.push({
                    elem: 'item',
                    content: [
                        {
                            block: 'link',
                            mods: {
                                pseudo: 'yes',
                                theme: 'dark-blue'
                            },
                            mix: [{
                                block: 'b-campaign-menu',
                                elem: 'change-geo'
                            }],
                            content: iget2('b-campaign-menu', 'geo', 'Настроить регионы показа')
                        }
                    ]
                });
            }
        }

        items.push({
            elem: 'item',
            elemMods: {
                mode: 'dropdown',
                for: 'search'
            },
            text: iget2('b-campaign-menu', 'poisk-po-kampanii', 'Поиск по кампании'),
            popupMix: {
                block: 'b-simple-dropdown',
                elem: 'popup',
                elemMods: { padding: 'no' }
            },
            popupJs: {
                directions: [
                    {
                        to: 'left',
                        axis: 'middle',
                        tail: 'middle',
                        offset: {
                            bottom: -40
                        }
                    },
                    'bottom-left-center'
                ]
            },
            content: {
                block: 'b-banners-search'
            }
        });

        data.tags_allowed == 'Yes' &&
            items.push({
                elem: 'item',
                elemMods: {
                    mode: 'dropdown',
                    for: 'tags'
                },
                text: iget2('b-campaign-menu', 'metki', 'Метки'),
                popupJs: {
                    directions: [
                        {
                            to: 'left',
                            axis: 'middle',
                            tail: 'middle',
                            offset: {
                                bottom: -20
                            }
                        },
                        'bottom-left-center'
                    ]
                },
                content: {
                    block: 'b-campaign-tags',
                    modelParams: this.ctx.modelParams,
                    js: {
                        readonly: opt.readonly
                    },
                    cid: data.campaign.cid
                }
            });
    }

    return items;
});
