block('b-campaign-menu').elem('media-panel').content()(function() {
    var items = [],
        data = this.data,
        pm = data.login_rights;

    (data.manager_uid || data.agency_uid || pm.super_control || pm.media_control) &&
    items.push({
        block: 'link',
        url: u.getUrl('createMediaplan', {
            cid: data.campaign.cid,
            ulogin: data.user_login
        }),
        content: iget2('b-campaign-menu', 'sozdat-mediaplan', 'Создать медиаплан')
    });

    if (this.options.showExportXls) {
        var positions = [
            {
                name: 'select',
                label: iget2('b-campaign-menu', 'vybrannye-pozicii', 'выбранные позиции')
            },
            {
                name: 'spec',
                label: iget2('b-campaign-menu', 'specrazmeshchenie', 'спецразмещение')
            },
            {
                name: 'max',
                label: iget2('b-campaign-menu', '1-oe-mesto', '1-ое место')
            },
            {
                name: 'min',
                label: iget2('b-campaign-menu', 'garantirovannye-pokazy', 'гарантированные показы')
            }
        ];

        items.push([
            {
                block: 'link',
                mix: [{
                    block: 'b-campaign-menu',
                    elem: 'export-to-xls'
                }],
                url: u.formatUrl({
                    path: '/registered/mediaplan' + data.campaign.cid + '.xls',
                    query: {
                        cmd: 'showMediaplan',
                        cid: data.campaign.cid,
                        xls: 1,
                        rnd: Math.round(Math.random() * 1e6),
                        ulogin: data.user_login
                    }
                }),
                target: '_top',
                content: iget2('b-campaign-menu', 'vygruzit-mediaplan-v-xls', 'Выгрузить медиаплан в XLS-файл')
            },
            {
                elem: 'xls-positions',
                content: positions.map(function(v) {
                    return {
                        elem: 'xls-pos',
                        content: {
                            block: 'checkbox',
                            mix: [{
                                block: 'b-campaign-menu',
                                elem: 'xls-pos-checkbox'
                            }],
                            mods: {
                                checked: v.name !== 'select' ? 'yes' : ''
                            },
                            checkboxAttrs: {
                                name: v.name
                            },
                            text: v.label
                        }
                    };
                })
            },
            (pm.super_control || pm.media_control || pm.manager_control) && {
                block: 'link',
                content: iget2('b-campaign-menu', 'vygruzka-mediaplana-v-xls', 'Выгрузка медиаплана в XLS-файл NEW'),
                url: u.formatUrl({
                    path: '/registered/mediaplan' + data.campaign.cid + '.xls',
                    query: {
                        cmd: 'showMediaplan',
                        for: 'big',
                        cid: data.campaign.cid,
                        xls: 1,
                        rnd: Math.round(Math.random() * 1e6),
                        ulogin: data.user_login
                    }
                }),
                target: '_top'
            }
        ]);
    }

    pm.role != 'media' &&
        items.push({
            block: 'link',
            url: u.getUrl('sendRequestMediaplan', {
                cid: data.campaign.cid,
                ulogin: data.user_login,
                to: 'media'
            }),
            target: '_blank',
            content: iget2('b-campaign-menu', 'otpravit-zayavku-na-mediaplan', 'Отправить заявку на медиаплан')
        });

    return items.map(function(v) {
        return {
            block: 'b-campaign-menu',
            elem: 'media-panel-item',
            content: v
        };
    });
});
