block('b-campaign-menu').elem('navigation').elemMod('type', 'camp').content()(function() {

    var data = this.data,
        pm = data.login_rights,
        opt = this.options,
        items = [],
        login = data.user_login,
        campaign = data.campaign,
        cid = campaign.cid,
        campActionParams = {
            cid: cid,
            ulogin: login
        },
        mediaType = campaign.mediaType,
        clientFeaturesAll = u.consts('clientFeaturesAll'),
        isInternalCampaign = u.consts('rights').enableInternalCampaigns && u.campaign.isInternal(campaign.type),
        isCreativeFreeInterface = clientFeaturesAll ? clientFeaturesAll.includes('CREATIVE_FREE_INTERFACE') : false,
        isMcbanner = campaign.mediaType === 'mcbanner',
        isContentPromotion = mediaType === 'content_promotion',
        formattedDate = u.moment().format('YYYYMMDD'),
        dateFrom = u.moment().subtract(7, 'days').format('YYYY-MM-DD'),
        dateTo = u.moment().format('YYYY-MM-DD'),
        statUrl = isMcbanner || isContentPromotion ?
            u.getUrl('showStat', {
                cid: cid,
                ulogin: login,
                stat_type: 'moc',
                single_camp: 1,
                show_stat: 1,
                date_from: dateFrom,
                date_to: dateTo
            }) :
            u.getUrl('showStat', {
                cid: cid,
                detail: 'Yes',
                types: 'days',
                ulogin: login,
                single_camp: 1,
                stat_type: 'moc',
                show_stat: 1,
                date_from: dateFrom,
                date_to: dateTo
            });

    (pm.manager_control || pm.placer_control || pm.super_control ||
        pm.support_control || pm.limited_support_control || pm.agency_control || pm.superreader_control) &&
        !u.consts('rights').isDnaHeaderAndSidebarEnabled &&
    items.push({
        elem: 'item',
        text: iget2('b-campaign-menu', 'vse-kampanii-klienta', 'Все кампании клиента'),
        url: isInternalCampaign ?
            u.formatUrl({
                path: '/dna/grid/campaigns',
                query: {
                    ulogin: login
                }
            }) :
            u.getUrl('showCamps', {
                ulogin: login
            })
    });

    if ((opt.campOptionsViewOnly || opt.campIsArch || pm.limited_support_control) && !pm.is_developer) {
        items.push({
            elem: 'item',
            text: iget2('b-campaign-menu', 'posmotret-parametry', 'Посмотреть параметры'),
            url: u.getUrl('showCampSettings', campActionParams)
        });
    } else if (!opt.campOptionsViewOnly && !pm.superreader_control || pm.is_developer) {
        items.push({
            elem: 'item',
            text: iget2('b-campaign-menu', 'izmenit-parametry', 'Изменить параметры'),
            url: u.getUrl('editCamp', campActionParams)
        });
    }

    (opt.campIsArch && !pm.superreader_control && !pm.media_control &&
        !campaign.currency_archived) && items.push({
            elem: 'item',
            text: iget2('b-campaign-menu', 'razarhivirovat-kampaniyu', 'Разархивировать кампанию'),
            url: u.getUrl('campUnarc', campActionParams)
        });

    // OrderID - id кампании в БК, если его нет, значит и статистики нет
    if (data.OrderID && data.OrderID !== '0') {
        items.push({
            elem: 'item',
            text: iget2('b-campaign-menu', 'posmotret-statistiku', 'Посмотреть статистику'),
            url: statUrl
        });

        if (!u.campaign.isCpm(mediaType) && (pm.ViewPdfReports || pm.media_control) &&
            !campaign.currency_archived && !isMcbanner && !isContentPromotion) {

            var reportParams = {
                ulogin: login
            };

            reportParams['cid_' + cid] = 1;
            items.push({
                elem: 'item',
                text: iget2('b-campaign-menu', 'zakaz-otchetov', 'Заказ отчетов'),
                url: u.getUrl('newPdfReport', reportParams)
            });
        }
    }

    (!u._.contains([
        'dynamic',
        'performance',
        'mcbanner',
        'content_promotion',
        'cpm_banner',
        'cpm_deals',
        'cpm_yndx_frontpage'
    ], mediaType) &&
    (!pm.media_control && data.allow_edit_camp || pm.superreader_control || pm.limited_support_control) &&
    !opt.campIsArch) && items.push({
        elem: 'item',
        text: iget2('b-campaign-menu', 'virtualnye-vizitki', 'Виртуальные визитки'),
        url: u.getUrl('manageVCards', campActionParams)
    });

    if (
        !u._.contains([
            'dynamic',
            'performance',
            'mcbanner',
            'content_promotion',
            'cpm_banner',
            'cpm_deals',
            'cpm_yndx_frontpage'
        ], mediaType) &&
        !opt.campIsArch &&
        campaign.can_export_in_excel
    ) {

        items.push({
            elem: 'item',
            text: iget2('b-campaign-menu', 'vygruzka-v-xls-xlsx', 'Выгрузка в XLS/XLSX'),
            url: u.getUrl('showExportedXlsList', {
                cid: cid,
                ulogin: login
            })
        });
    }

    if (opt.campMediaType === 'performance') { // DIRECT-58475 добавляем ссылки только для смарт

        if (!isCreativeFreeInterface) {

            items.push({
                elem: 'item',
                text: iget2('b-campaign-menu', 'kreativy-dlya-smart-bannerov', 'Креативы для смарт-баннеров'),
                url: u.getUrl('showCreatives', u._.extend({ ulogin: login }, { retpath: u.getCurrentUrl() }))
            });
        }

        items.push({
            elem: 'item',
            text: iget2('b-campaign-menu', 'upravlenie-fidami', 'Управление фидами'),
            url: u.getUrl('showFeeds', u._.extend({ ulogin: login }, { retpath: u.getCurrentUrl() }))
        });
    }

    (pm.super_control || pm.support_control) && items.push({
        elem: 'item',
        text: iget2('b-campaign-menu', 'show-logviewer', 'Просмотр логов'),
        url: u.formatUrl({
            path: 'logviewer/',
            // ссылка на logViewer формируется через запятую
            // ppclog_cmd, текущая дата, номер страницы, кол-во строк на странице, кол-во дефолтных чекбоксов,
            // поле фильтрации, значение поля
            hash: [
                'ppclog_cmd',
                formattedDate + 'T000000', // начало периода (сегодняшний день)
                formattedDate + 'T235959', // конец периода (сегодняшний день)
                '1:100', // номер страницы:кол-во строк на странице
                '0', // кол-во дефолтных чекбоксов
                'cid', // поле фильтрации (номер кампании)
                cid // значение поля фильтрации
            ].join(',')
        })
    });

    !u._.contains(['content_promotion'], campaign.mediaType) && items.push({
        elem: 'item',
        text: [
            iget2('b-campaign-menu', 'istoria-izmemenii', 'История изменений'),
            {
                block: 'b-beta',
                mods: { type: 'symbol' }
            }
        ],
        url: u.formatUrl({
            path: '/dna/log/',
            query: {
                ulogin: login,
                cid: cid
            }
        })
    });

    return items;
});
