block('b-campaign-menu').elem('navigation').elemMod('type', 'campdate')(

    content()(function() {
        var data = this.data,
            form = data.FORM,
            hasCids = form.cid,
            isInternalCampaigns = u.consts('rights').enableInternalCampaigns && u.campaign.hasInternal(data.available_camp_types),
            cids = [],
            formattedCids;

        if (hasCids) {
            cids = data.orders.map(function(order) {
                return order.cid;
            })
        }

        if (cids.length === 0) {
            formattedCids = form.cid;
        } else if (hasCids) {
            formattedCids = cids.join(', ')
        }

        return [
            !u.consts('rights').isDnaHeaderAndSidebarEnabled && {
                elem: 'item',
                text: hasLoginRights('is_any_client') ? iget2('b-campaign-menu', 'vse-kampanii', 'Все кампании') : iget2('b-campaign-menu', 'vse-kampanii-klienta', 'Все кампании клиента'),
                url: isInternalCampaigns ?
                    u.formatUrl({
                        path: '/dna/grid/campaigns',
                        query: {
                            ulogin: data.user_login
                        }
                    }) :
                    u.getUrl('showCamps', {
                        ulogin: data.user_login
                    })
            },
            {
                elem: 'item',
                text: iget2('b-campaign-menu', 'zakaz-otchetov', 'Заказ отчетов'),
                url: u.getUrl('newPdfReport', {
                    ulogin: data.user_login
                })
            },
            {
                elem: 'item',
                text: [
                    iget2('b-campaign-menu', 'istoria-izmemenii', 'История изменений'),
                    {
                        block: 'b-beta',
                        mods: { type: 'symbol' }
                    }
                ],
                url: u.formatUrl({
                    path: '/dna/log/',
                    query: {
                        ulogin: data.user_login,
                        cid: formattedCids
                    }
                })
            }
        ];
    })
);
