//@heliarian копипаст с b-campaign-menu__navigation_type_camp с удаленными блоками, дабы не плодить  if-ы
block('b-campaign-menu').elem('navigation').elemMod('type', 'mobile-content-camp').content()(function() {

    var data = this.data,
        pm = data.login_rights,
        opt = this.options,
        items = [],
        login = data.user_login,
        campaign = data.campaign,
        isInternalCampaign = u.consts('rights').enableInternalCampaigns && u.campaign.isInternal(campaign.type),
        campActionParams = {
            cid: campaign.cid,
            ulogin: login
        };

    (pm.manager_control || pm.placer_control || pm.super_control ||
        pm.support_control || pm.limited_support_control || pm.superreader_control) &&
        !u.consts('rights').isDnaHeaderAndSidebarEnabled &&
    items.push({
        elem: 'item',
        text: iget2('b-campaign-menu', 'vse-kampanii-klienta', 'Все кампании клиента'),
        url: isInternalCampaign ?
            u.formatUrl({
                path: '/dna/grid/campaigns',
                query: {
                    ulogin: login
                }
            }) :
            u.getUrl('showCamps', {
                ulogin: login
            })
    });

    if ((opt.campOptionsViewOnly || opt.campIsArch) && !pm.is_developer) {
        items.push({
            elem: 'item',
            text: iget2('b-campaign-menu', 'posmotret-parametry', 'Посмотреть параметры'),
            url: u.getUrl('showCampSettings', campActionParams)
        });
    } else if (!opt.campOptionsViewOnly && !pm.superreader_control || pm.is_developer) {
        items.push({
            elem: 'item',
            text: iget2('b-campaign-menu', 'izmenit-parametry', 'Изменить параметры'),
            url: u.getUrl('editCamp', campActionParams)
        });
    }

    (opt.campIsArch && !pm.superreader_control && !pm.media_control &&
        !campaign.currency_archived) && items.push({
            elem: 'item',
            text: iget2('b-campaign-menu', 'razarhivirovat-kampaniyu', 'Разархивировать кампанию'),
            url: u.getUrl('campUnarc', campActionParams)
        });

    if (data.OrderID && data.OrderID !== '0') {
        var dateFrom = u.moment().subtract(7, 'days').format('YYYY-MM-DD'),
            dateTo = u.moment().format('YYYY-MM-DD');

        items.push({
            elem: 'item',
            text: iget2('b-campaign-menu', 'posmotret-statistiku', 'Посмотреть статистику'),
            url: u.getUrl('showStat', {
                cid: campaign.cid,
                detail: 'Yes',
                types: 'days',
                ulogin: login,
                stat_type: 'moc',
                single_camp: 1,
                show_stat: 1,
                date_from: dateFrom,
                date_to: dateTo
            })
        });

        if ((pm.ViewPdfReports || pm.media_control) && !campaign.currency_archived) {

            var reportParams = {
                ulogin: login
            };

            reportParams['cid_' + campaign.cid] = 1;
            items.push({
                elem: 'item',
                text: iget2('b-campaign-menu', 'zakaz-otchetov', 'Заказ отчетов'),
                url: u.getUrl('newPdfReport', reportParams)
            });
        }
    }

    if (!opt.campIsArch && campaign.can_export_in_excel) {
        items.push({
            elem: 'item',
            text: iget2('b-campaign-menu', 'vygruzka-v-xls-xlsx', 'Выгрузка в XLS/XLSX'),
            url: u.getUrl('showExportedXlsList', {
                cid: campaign.cid,
                ulogin: login
            })
        });
    }

    items.push({
        elem: 'item',
        text: [
            iget2('b-campaign-menu', 'istoria-izmemenii', 'История изменений'),
            {
                block: 'b-beta',
                mods: { type: 'symbol' }
            }
        ],
        url: u.formatUrl({
            path: '/dna/log/',
            query: {
                ulogin: login,
                cid: campaign.cid
            }
        })
    });

    return items;
});
