block('b-campaign-menu').elem('navigation').elemMod('type', 'stat').content()(function() {

    var data = this.data,
        login = data.user_login,
        campaign = data.campaign,
        actionParams = {
            cid: campaign.cid,
            ulogin: login
        },
        isInternalCampaign = u.consts('rights').enableInternalCampaigns && u.campaign.isInternal(campaign.type),
        canEditMedia = hasLoginRights(
            'super_control',
            'placer_control',
            'agency_control',
            'support_control',
            'manager_control'),
        items = [{
            elem: 'item',
            text: iget2('b-campaign-menu', 'pereyti-v-kampaniyu', 'Перейти в кампанию'),
            url: isInternalCampaign ?
                u.formatUrl({
                    path: '/dna/grid/groups',
                    query: {
                        ulogin: actionParams.ulogin,
                        'campaigns-ids': actionParams.cid
                    }
                }) :
                u.getUrl('showCamp', actionParams)
        }],
        params;

    data.canEditMedia = canEditMedia;

    if (this.options.campOptionsViewOnly) {
        items.push(
            hasLoginRights('superreader_control') || campaign.currency_archived ?
                {
                    elem: 'item',
                    text: iget2('b-campaign-menu', 'posmotret-parametry', 'Посмотреть параметры'),
                    url: u.getUrl('showCampSettings', actionParams)
                } : {
                    elem: 'item',
                    text: iget2('b-campaign-menu', 'izmenit-parametry', 'Изменить параметры'),
                    url: u.getUrl('editCamp', this.extend(actionParams, {
                        retpath: u.getCurrentUrl()
                    }))
                });

        if (hasLoginRights('ViewPdfReports') &&
            !u._.contains(['mcbanner', 'content_promotion', 'cpm_banner', 'cpm_deals', 'cpm_yndx_frontpage','cpm_price'], campaign.mediaType)) {
            params = {
                ulogin: login
            };

            params['cid_' + campaign.cid] = 1;

            items.push({
                elem: 'item',
                text: iget2('b-campaign-menu', 'zakaz-otchetov', 'Заказ отчетов'),
                url: u.getUrl('newPdfReport', params)
            });
        }

        if (campaign.archived == 'Yes') {
            !u._.contains(['cpm_price'], campaign.mediaType) && !campaign.currency_archived && items.push({
                elem: 'item',
                elemMods: {
                    type: 'only-red'
                },
                content: {
                    block: 'link',
                    content: iget2('b-campaign-menu', 'razarhivirovat', 'Разархивировать'),
                    url: isInternalCampaign ?
                        u.getUrl('ajaxInternalAdsCampaignAction', {
                            cid: actionParams.cid,
                            ulogin: actionParams.ulogin,
                            action: 'unarchive'
                        }) :
                        u.getUrl('campUnarc', this.extend(actionParams, {
                            tab: 'arch'
                        }))
                }
            });
        } else {
            !u._.contains(['cpm_price'], campaign.mediaType) && canEditMedia && campaign.OrderID != 0 && items.push(
                campaign.statusShow == 'No' ?
                    {
                        elem: 'item',
                        elemMods: { type: 'only-red', campStateSwitcher: 'yes' },
                        content: {
                            block: 'link',
                            url: isInternalCampaign ?
                                u.getUrl('ajaxInternalAdsCampaignAction', {
                                    cid: actionParams.cid,
                                    ulogin: actionParams.ulogin,
                                    action: 'resume'
                                }) :
                                u.getUrl('resumeCamp', actionParams),
                            content: iget2('b-campaign-menu', 'vklyuchit', 'Включить')
                        }
                    } :
                    {
                        elem: 'item',
                        elemMods: { campStateSwitcher: 'yes' },
                        content: {
                            block: 'link',
                            mods: {
                                'need-confirm': u.campaign.isCpm(campaign.mediaType) && campaign.brand_survey_id ?
                                    'yes' :
                                    ''
                            },
                            url: isInternalCampaign ?
                                u.getUrl('ajaxInternalAdsCampaignAction', {
                                    cid: actionParams.cid,
                                    ulogin: actionParams.ulogin,
                                    action: 'stop'
                                }) :
                                u.getUrl('stopCamp', actionParams),
                            content: iget2('b-campaign-menu', 'ostanovit', 'Остановить'),
                            confirm: iget2(
                                'b-campaigns-list-item',
                                'dont-stop-campaign-with-brand-lift',
                                'Исследование Brand Lift проводится на протяжении всей кампании. Не останавливайте кампанию досрочно — собранных данных может оказаться недостаточно для достоверных выводов'
                            ),
                            confirmOptions: {
                                textYes: iget2('b-campaign-menu', 'yes', 'Остановить'),
                                textNo: iget2('b-campaign-menu', 'no','Отменить'),
                            }
                        }
                    });
        }

        !u._.contains(['cpm_price'], campaign.mediaType) && campaign.statusNoPay == 'No' && !hasLoginRights('media_control') && campaign.lowMonthShowsNoPay &&
            (campaign.statusModerate == 'Yes' || hasLoginRights('super_control', 'manager_control') &&
                !(hasLoginRights('is_any_client') && !data.allow_edit_camp)) &&
            items.push({
                elem: 'item',
                elemMods: {
                    type: 'info',
                    warn: 'yes'
                },
                content: iget2('b-campaign-menu', 'oplata-nedostupna', 'Оплата недоступна') + '!&nbsp;' + iget2('b-campaign-menu', 'neobhodimo-uvelichit-trafik-paketa-103', 'Необходимо увеличить трафик пакета')
            });

        !u._.contains(['cpm_price'], campaign.mediaType) && !campaign.sum && !isInternalCampaign && items.push({
            elem: 'item',
            content: {
                block: 'link',
                mods: {
                    'need-confirm': 'yes',
                    theme: 'dark-blue'
                },
                confirm: iget2('b-campaign-menu', 'vy-uvereny-chto-hotite', 'Вы уверены, что хотите удалить кампанию?'),
                url: u.getUrl('delCamp', actionParams),
                content: iget2('b-campaign-menu', 'udalit-kampaniyu', 'Удалить кампанию')
            }
        });

        (canEditMedia || hasLoginRights('superreader_control') || hasLoginRights('limited_support_control')) &&
            !u.consts('rights').isDnaHeaderAndSidebarEnabled &&
            items.push({
                elem: 'item',
                elemMods: {
                    type: 'indent'
                },
                content: {
                    block: 'link',
                    url: isInternalCampaign ?
                        u.formatUrl({
                            path: '/dna/grid/campaigns',
                            query: {
                                ulogin: login
                            }
                        }) :
                        u.getUrl('showCamps', {
                            mediaType: data.mediaType || 'text',
                            ulogin: login
                        }),
                    content: iget2('b-campaign-menu', 'vse-kampanii-klienta', 'Все кампании клиента')
                }
            });

    } else {
        items.push({
            elem: 'item',
            text: iget2('b-campaign-menu', 'prosmotr-parametrov-kampanii', 'Просмотр параметров кампании'),
            url: u.getUrl('showCampSettings', actionParams)
        });

        if (hasLoginRights('media_control') &&
            !u._.contains(['mcbanner', 'content_promotion', 'cpm_banner', 'cpm_deals', 'cpm_yndx_frontpage', 'cpm_price'], campaign.mediaType)) {
            params = {
                ulogin: login
            };

            params['cid_' + campaign.cid] = 1;

            items.push({
                elem: 'item',
                text: iget2('b-campaign-menu', 'zakaz-otchetov', 'Заказ отчетов'),
                url: u.getUrl('newPdfReport', params)
            });
        }
    }

    !u._.contains(['content_promotion'], campaign.mediaType) && items.push({
        elem: 'item',
        text: [
            iget2('b-campaign-menu', 'istoria-izmemenii', 'История изменений'),
            {
                block: 'b-beta',
                mods: { type: 'symbol' }
            }
        ],
        url: u.formatUrl({
            path: '/dna/log/',
            query: {
                ulogin: login,
                cid: campaign.cid
            }
        })
    });

    return items;
});
