block('b-campaign-menu').elem('special-actions').content()(function() {
    var data = this.data,
        pm = data.login_rights,
        opt = this.options,
        pay = data.statusNoPay == 'No',
        optimize = data.optimize_camp,
        agencyUnBind = data.agency_unbind,
        items = [],
        mediaType = data.campaign.mediaType,
        isDynamicMediaBanners = mediaType === 'performance',
        isDynamicCampaign = mediaType === 'dynamic',
        isMcbanner = mediaType === 'mcbanner',
        isContentPromotion = mediaType === 'content_promotion',
        isCpmBannerCampaign = u.campaign.isCpm(mediaType),
        hasMediaplans = !isDynamicMediaBanners && !isDynamicCampaign && !isMcbanner &&
        !isContentPromotion && !isCpmBannerCampaign;

    pm.AdmBanPay && !opt.campIsArch && (pay || !agencyUnBind) &&
        items.push({
            elem: 'item',
            elemMods: {
                pseudo: pay ? 'yes' : 'no'
            },
            content: {
                block: 'link',
                mods: {
                    'need-confirm': 'yes',
                    theme: 'dark-blue'
                },
                mix: [{
                    block: 'b-campaign-menu',
                    elem: 'ban-pay'
                }],
                confirm: pay ?
                    iget2('b-campaign-menu', 'vy-deystvitelno-hotite-zapretit', 'Вы действительно хотите запретить оплату?') : iget2('b-campaign-menu', 'vy-deystvitelno-hotite-razreshit', 'Вы действительно хотите разрешить оплату?'),

                url: u.getUrl(pay ? 'admBanPay' : 'admUnBanPay', {
                    cid: data.campaign.cid,
                    ulogin: data.user_login
                }),
                content: pay ? iget2('b-campaign-menu', 'zapretit-oplatu', 'Запретить оплату') : iget2('b-campaign-menu', 'razreshit-oplatu', 'Разрешить оплату')
            }
        });

    if (hasMediaplans && !opt.statPage && !opt.campIsArch) {
        if (pm.super_control || pm.media_control || (data.manager_uid || data.agency_uid) && !opt.campIsArch &&
            (pm.manager_control || pm.support_control || pm.placer_control)) {
            items.push({
                elem: 'item',
                elemMods: {
                    mode: 'dropdown'
                },
                mix: [{
                    block: 'b-campaign-menu',
                    elem: 'mediaplan'
                }],
                text: iget2('b-campaign-menu', 'panel-mediaplana', 'Панель медиаплана'),
                popupJs: {
                    directions: [
                        {
                            to: 'left',
                            axis: 'middle',
                            tail: 'middle',
                            offset: {
                                bottom: -20
                            }
                        },
                        'bottom-left-center'
                    ]
                },
                content: {
                    block: 'b-campaign-menu',
                    elem: 'media-panel'
                }
            });
        }

        !isDynamicMediaBanners && !isMcbanner && !isContentPromotion && !isCpmBannerCampaign &&
            (!optimize || !optimize.status.match(/New|InProcess|Ready/)) &&
            !(data.manager_uid || data.agency_uid) && (pm.support_control || pm.super_control || pm.media_control) &&
            items.push({
                elem: 'item',
                elemMods: {
                    mode: 'dropdown'
                },
                text: iget2('b-campaign-menu', 'zayavka-na-pervuyu-pomoshch', 'Заявка на Первую помощь'),
                popupJs: {
                    directions: [
                        {
                            to: 'left',
                            axis: 'middle',
                            tail: 'middle',
                            offset: {
                                bottom: -50
                            }
                        },
                        'bottom-left-center'
                    ]
                },
                content: {
                    block: 'b-campaign-help-request'
                }
            });

        (pm.super_control || pm.media_control && optimize && optimize.MediaUID != data.UID) &&
        optimize && optimize.MediaUID && !optimize.status.match(/Accept|Reject/) &&
            items.push({
                elem: 'item',
                elemMods: pm.super_control ?
                    { type: 'info' } :
                    {
                        type: 'info',
                        warn: 'yes'
                    },
                content: [
                    iget2('b-campaign-menu', 'dannaya-kampaniya-optimiziruetsya-mediaplannerom', 'Данная кампания оптимизируется медиапланнером:'),
                    '&nbsp;',
                    {
                        elem: 'name',
                        content: optimize.MediaFIO
                    },
                    !pm.super_control && '<br/><br/>',
                    !pm.super_control && iget2('b-campaign-menu', 'vy-ne-mozhete-optimizirovat', 'Вы не можете оптимизировать данную кампанию!')
                ]
            });
    }

    opt.media_show_plan && items.push({
        elem: 'item',
        elemMods: {
            mode: 'dropdown'
        },
        text: iget2('b-campaign-menu', 'poisk-po-blokam', 'Поиск по блокам'),
        popupJs: {
            directions: ['left-middle-middle', 'bottom-left-center']
        },
        content: {
            block: 'b-mediaplan-search-block'
        }
    });

    return items;
});
