/**
 * @param {Object} modelParams параметры модели кампании для данного блока
 * @param {String} modelParams.name
 * @param {String} modelParams.id
 * @param {string} modelParams.translocalTreeType
 * @param {Object} options
 */
block('b-campaign-menu')(

    def()(function() {
        this.ctx.modelParams = this.ctx.modelParams || {
            name: 'm-campaign'
        };

        return applyNext({
            options: this.ctx.options || {}
        });
    }),

    js()(function() {
        return {
            modelParams: this.ctx.modelParams,
            showExportXls: this.options.showExportXls,
            campaignType: this.data.campaign ? this.data.campaign.mediaType : undefined,
        };
    }),

    content()(function() {
        var options = this.ctx.options,
            modelParams = this.ctx.modelParams,
            isMoc = Boolean(options.isMoc),
            isMol = Boolean(options.isMol),
            contentPromotionType = (this.data.campaigns_list && this.data.campaigns_list[0] || {})['content_promotion_type'],
            availableCampaignTypesForConversionsStat = [
                'text',
                'dynamic',
                'performance',
            ],
            campaignId = undefined,
            showConversionsStat = false,
            checkCampaignType = function(campaignType) {
                return availableCampaignTypesForConversionsStat.includes(campaignType) ||
                    campaignType === 'mobile_content' && u.consts('isCpaPayForConversionsMobileContentStrategyAllowed');
            };

        if (isMoc) {
            var campaign = this.data.campaign || {};

            campaignId = campaign.cid;
            showConversionsStat = checkCampaignType(campaign.mediaType);
        }

        if (isMol) {
            showConversionsStat = u.consts('showConversionReportForLogin') &&
            (this.data.campaigns_list || []).some(function(campaign) {
                return checkCampaignType(campaign.type);
            });
        }

        return [
            contentPromotionType !== 'collection' && {
                elem: 'navigation',
                modelParams: modelParams,
                elemMods: options.navMods || {}
            },
            (isMoc || isMol) && showConversionsStat && {
                elem: 'conversions-stat-link',
                campaignId: campaignId
            },
            options.specialActions && {
                elem: 'special-actions',
                modelParams: modelParams,
                elemMods: options.specialMods || {}
            },
            options.bannerActions && {
                elem: 'banner-actions',
                modelParams: modelParams,
                elemMods: options.bannerMods || {}
            }
        ];
    }),

    elem('item')(

        content()(function() {
            return this.ctx.content || {
                block: 'link',
                mix: {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamp: {
                                navigation: this.ctx.text
                            }
                        }
                    }
                },
                url: this.ctx.url || '#',
                content: this.ctx.text
            };
        }),

        elemMod('mode', 'dropdown').content()(function() {
            return {
                block: 'b-simple-dropdown',
                title: this.ctx.text,
                popupJs: this.ctx.popupJs,
                popupMix: this.ctx.popupMix,
                popupMods: this.ctx.popupMods,
                content: this.ctx.content
            };
        })
    )
);
