BEM.DOM.decl('b-campaign-menu', {

    onSetMod: {

        js: function() {
            var actionParams,
                changeGeoLink = this.findBlockOn('change-geo', 'link'),
                conversionsLink = this.elem('conversions-stat-link');

            this._subMan = BEM.create('i-subscription-manager');
            this.cid = BEM.MODEL.getOrCreate(this.params.modelParams).get('cid');

            actionParams = {
                cid: this.cid,
                ulogin: u.consts('ulogin'),
                csrf_token: u.consts('csrfToken')
            };

            if (this.params.showExportXls) {
                this.bindTo('export-to-xls', 'click', this._exportToXls);
                this._xlsPositions = this.findBlocksOn('xls-pos-checkbox', 'checkbox');
            }

            changeGeoLink && changeGeoLink.on('click', this._openChangeGeoPopup, this);
            conversionsLink && this._subMan.on(conversionsLink, 'click', this._downloadConversionsReport);

            /* jshint ignore:start */
            if (this.elem('navigation', 'type', 'stat')) {
                this.channel('campState').on('change', function(e, data) {
                    BEM.DOM.replace(
                        this.elem('item', 'campStateSwitcher', 'yes'),
                        BEMHTML.apply(
                            data.state != 'on' ?
                                {
                                    block: 'b-campaign-menu',
                                    elem: 'item',
                                    elemMods: { type: 'only-red', campStateSwitcher: 'yes' },
                                    content: {
                                        block: 'link',
                                        content: iget2('b-campaign-menu', 'vklyuchit', 'Включить'),
                                        url: u.getUrl('resumeCamp', actionParams)
                                    }
                                } :
                                {
                                    block: 'b-campaign-menu',
                                    elem: 'item',
                                    elemMods: { campStateSwitcher: 'yes' },
                                    content: {
                                        block: 'link',
                                        content: iget2('b-campaign-menu', 'ostanovit', 'Остановить'),
                                        url: u.getUrl('stopCamp', actionParams)
                                    }
                                }));

                }, this);
            }
            /* jshint ignore:end */
        }

    },

    _exportToXls: function(e) {
        var posParams = '';

        this._xlsPositions.forEach(function(pos) {
            pos.isChecked() && (posParams += '&show_plan=' + pos.elem('control').attr('name'));
        });

        e.data.domElem[0].href += posParams;

        return true;
    },

    _downloadConversionsReport: function() {
        BEM.blocks['b-metrika2'].reachGoal('DOWNLOAD_CSV_CONVERSIONS_REPORT');
    },

    _openChangeGeoPopup: function() {
        var dna = window.dna;

        if (!dna) {
            return;
        }

        if (this._changeGeoPopup) {
            BEM.DOM.destruct(this._changeGeoPopup);
        }

        try {
            this._changeGeoPopup = BEM.DOM.append($('body'), BEMHTML.apply({
                block: 'b-campaign-menu',
                elem: 'change-geo-popup'
            }));

            dna.reactDOMRender(
                dna.reactCreateElement(dna.components.RegionsTransformEditorWrapper, {
                    login: u.consts('ulogin'),
                    campaignsIds: [this.cid],
                    campaignsTypes: this.params.campaignType ? [this.params.campaignType] : [],
                    actionCallbacks: {
                        onSuccessApply: function() {
                            window.setTimeout(function() {
                                window.location.reload();
                            }, 100);
                        }
                    },
                    translocalGeotreeType: this.params.modelParams.translocalTreeType === 'ru' ? 'RUSSIAN' : 'GLOBAL',
                    clientFeatures: u.consts('clientFeaturesAll'),
                    operatorFeatures: u.consts('operatorFeaturesAll')
                }, null),
                this._changeGeoPopup[0]
            );
        } catch (err) {
            BEM.blocks['b-user-dialog'].alert({
                message: iget2('b-campaign-menu', 'dna-loading-failed', 'Что-то пошло не так')
            });
        }
    }
});
