/**
 * Блок мониторинга сайта
 *
 * @param {Number} ctx.userYaCounters счётчики метрики
 * @param {Object} ctx.campaign объект кампании
 * @param {Number} ctx.campaign.statusMetricaControl флаг остановки объявления при неработающем сайте
 * @param {Object} ctx.campaign.sms_flags объект флагов про смс
 * @param {Boolean} [ctx.campaign.sms_flags.notify_metrica_control_sms] флаг уведомления по смс
 * @param {String} [ctx.smsPhone=''] телефон для отправки sms
 * @param {Boolean} [ctx.requireMetrika=true]
 */
block('b-campaign-metrica-control')(

    def()(function() {
        var ctx = this.ctx,
            smsPhone = ctx.smsPhone,
            requireMetrika = ctx.requireMetrika;

        typeof smsPhone == 'string' || (smsPhone = '');
        typeof requireMetrika == 'boolean' || (requireMetrika = true);

        return applyNext({
            'ctx.smsPhone': smsPhone,
            'ctx.requireMetrika': requireMetrika
        });
    }),

    js()(function() {
        return {
            modelName: this.ctx.modelName || 'm-campaign',
            smsPhone: this.ctx.smsPhone,
            requireMetrika: this.ctx.requireMetrika,
            userYaCounters: this.ctx.userYaCounters || 0
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            hasSmsPhone = !!ctx.smsPhone,
            campaign = ctx.campaign,
            isEditable = this.ctx.isEditable;

        return [
            {
                block: 'checkbox',
                mods: {
                    checked: campaign.statusMetricaControl ? 'yes' : '',
                    disabled: isEditable ? undefined : 'yes'
                },
                mix: [{
                    block: 'b-campaign-metrica-control',
                    elem: 'status'
                }],
                checkboxAttrs: {
                    value: 1,
                    name: 'statusMetricaControl'
                },
                text: ctx.useBanners ?
                    iget2(
                        'b-campaign-metrica-control',
                        'ostanavlivat-bannery-pri-nerabotayushchem',
                        'Останавливать баннеры при неработающем сайте'
                    ) :
                    iget2(
                        'b-campaign-metrica-control',
                        'ostanavlivat-obyavleniya-pri-nerabotayushchem',
                        'Останавливать объявления при неработающем сайте'
                    )
            },
            {
                block: 'b-help-link',
                mods: { type: 'modal' },
                stretched: true,
                width: 1100,
                url: u.getHelpUrl('availability-monitoring')
            },
            '&nbsp;',
            ctx.requireMetrika && iget2('b-campaign-metrica-control', 'trebuetsya-link-metrika', '(требуется {link})', {
                link: function(text) {

                    /* jshint -W117 */
                    // dima117a@todo: убрать этот хинт после выполнения задачи DIRECT-51981
                    return {
                        block: 'link',
                        content: text,
                        target: '_blank',
                        url: getUrl(hasLoginRights('agency_control') ? 'yaAddCounter' : 'yaShowUserCounters', {
                            ulogin: u.consts('ulogin')
                        })
                    };

                    /* jshint +W117 */
                    // dima117a@todo: убрать этот хинт после выполнения задачи DIRECT-51981
                }(iget2('b-campaign-metrica-control', 'trebuetsya-link-metrika-param-link', 'Метрика')),

                context: 'link - Метрика'
            }),
            {
                elem: 'row',
                elemMods: { hidden: !isEditable || campaign.statusMetricaControl ? undefined : 'yes' },
                content: [
                    {
                        block: 'checkbox',
                        mods: {
                            checked: hasSmsPhone && campaign.sms_flags &&
                                campaign.sms_flags.notify_metrica_control_sms ?
                                    'yes' :
                                    '',
                            disabled: isEditable && hasSmsPhone && campaign.statusMetricaControl == 1 ?
                                undefined :
                                'yes'
                        },
                        mix: [{
                            block: 'b-campaign-metrica-control',
                            elem: 'sms'
                        }],
                        text: iget2('b-campaign-metrica-control', 'uvedomlyat-po-sms', 'Уведомлять по СМС')
                    },
                    {
                        elem: 'help',
                        isEditable: isEditable
                    }
                ]
            }
        ];
    }),

    elem('help').match(function() {
        return !this.ctx.isEditable;
    }).def()(function() {
        return '';
    }),

    elem('help').match(function() {
        return this.ctx.isEditable;
    }).replace()(function() {
        return [
            '&nbsp;(',
            {
                block: 'b-help-link',
                mods: { type: 'modal' },
                mix: [{ block: 'b-campaign-metrica-control', elem: 'help' }],
                stretched: true,
                width: '90%',
                url: u.getHelpUrl('sms-alerts'),
                text: iget2('b-campaign-metrica-control', 'kak-nastroit', 'как настроить?')
            },
            ')'
        ];
    })
);
