/**
 *
 * @event b-campaign-metrica-control#site-monitoring-change Изменение состояния чекбокса "Останавливать объявление при не работающем сайте"
 * @event b-campaign-metrica-control#notice-smc Изменение состояния чекбокса "Уведомлять по smc"
 *
 * @fires b-campaign-metrica-control#site-monitoring-change
 * @fires b-campaign-metrica-control#notice-smc
 */
BEM.DOM.decl('b-campaign-metrica-control', {
    onSetMod: {
        js: function() {
            this._sms = this.findBlockOn('sms', 'checkbox');
            this._sms.on('change', this._onSmsCbxChange, this);
            this._model = BEM.MODEL.getOne(this.params.modelName);

            this._model.on('notify_metrica_control_sms', 'change', this._onModelSmsChange, this);

            this.findBlockOn('status', 'checkbox').on('change', this._onStatusCbxChange, this);
        }
    },

    /**
     * Обработчик изменения состояния чекбокса статуса метрики
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onStatusCbxChange: function(e, data) {
        var checked = e.target.isChecked();

        this.toggleMod(this.elem('row'), 'hidden', '', 'yes', checked);

        if (this.params.smsPhone) {
            this._toggleSms(checked);
        }

        this.params.requireMetrika && checked && this.params.userYaCounters == 0 &&
            BEM.blocks['b-confirm'].alert(
                iget2(
                    'b-campaign-metrica-control',
                    'monitoring-trebuet-ustanovki-schyotchika',
                    'Мониторинг требует установки счётчика Метрики. Пожалуйста, заведите счётчик в разделе "Метрика" и установите на сайте.'
                ));

        this._model.set('statusMetricaControl', checked ? '1' : '0');
        this.trigger('site-monitoring-change');
    },

    /**
     * Обработчик изменения состояния чекбокса отправки смс. Меняет поле модели b-sms-notification
     * @param {Event} e
     * @private
     */
    _onSmsCbxChange: function(e) {
        this._model.set('notify_metrica_control_sms', e.target.isChecked());
        this.trigger('notice-smc');
    },

    /**
     * Обработчик изменения поля notify_metrica_control_sms. Изменяет состояние чекбокса
     * @param {event} e
     * @param {Object} data
     * @private
     */
    _onModelSmsChange: function(e, data) {
        this._sms.setMod('checked', data.value == 1 ? 'yes' : '');
    },

    /**
     * Переключает чекбокс с смс
     * @param {Boolean} toggle true -> сделать активным
     * @private
     */
    _toggleSms: function(toggle) {
        this._sms.setMod('disabled', toggle ? '' : 'yes');

        // если деактивируем - галочку снимаем тоже
        if (!toggle)
            this._sms.setMod('checked', '');
    }
});
