BEM.DOM.decl('b-campaign-optimize', {

    onSetMod: {

        js: function() {
            var declinePopup = this.findBlockInside('popup'),
                campInfo = this.findBlockOutside('b-campaign-info'),
                form = campInfo.elem('main-form'),
                comment = this.findBlockOn('decline-comment', 'input'),
                selectReason = this.findBlockInside('reason', 'select');

            this._declineComment = this.findBlockOn(this.elem('decline-comment'), 'input');

            this.__self.blocks['select'].on(this.elem('reason'), 'change', function(event) {
                var params = event.target.params;

                params && params.action === 'select-reason' && this._setComment(params.comments[selectReason.val()]);
            }, this);

            this.findBlockOn('cancel', 'button').on('click', function() {
                declinePopup.hide();
            });

            this.findBlockOn('decline', 'button').on('click', function() {
                campInfo.elem('opt-type').val('declineOptimizing');
                campInfo.elem('cmd-input').val('declineOptimizing');
                campInfo.elem('opt-decline-reason').val(selectReason.val());
                campInfo.elem('opt-decline-comment').val(comment.val());

                BEM.blocks['b-confirm'].open({
                    message: iget2('b-campaign-optimize', 'vy-deystvitelno-hotite-zakonchit', 'Вы действительно хотите закончить оптимизацию?'),
                    onYes: function() {
                        form.submit();
                    }
                });
            });
        }
    },

    _setComment: function(value) {
        this._declineComment.val(value);
    }
});
