/**
 * Заявка на оптимизацию кампаний
 * @param ctx.campaign {Object} объект кампании
 * @param ctx.num {Number} порядковый номер
 */
block('b-campaign-optimizer-request').elem('list-row-content')(

    mix()({
        elem: 'list-row'
    }),

    content()(function() {
        var ctx = this.ctx,
            campaign = ctx.campaign;

        return [
            {
                block: 'checkbox',
                mix: {
                    block: this.block,
                    elem: 'list-col-checkbox'
                },
                mods: { size: 's' },
                js: { live: true },
                checkboxAttrs: {
                    name: 'campaign',
                    value: campaign.cid
                }
            },
            {
                elem: 'list-col-num',
                content: ctx.num
            },
            {
                elem: 'list-col-name',
                elemMods: { hide: 'yes' },
                content: [
                    {
                        elem: 'campaign-name',
                        content: [
                            {
                                block: 'link',
                                url: u.getUrl('showCamp', {
                                    cid: campaign.cid,
                                    ulogin: campaign.login
                                }),
                                target: '_blank',
                                content: campaign.name
                            },
                            ' (№' + campaign.cid + ')'
                        ]
                    },
                    {
                        elem: 'campaign-item-order-note',
                        elemMods: { hide: 'yes', cid: '' + campaign.cid },
                        content: {
                            block: 'input',
                            mods: {
                                size: 's',
                                type: 'textarea'
                            },
                            content: {
                                elem: 'control',
                                attrs: {
                                    placeholder: iget2(
                                        'b-campaign-optimizer-request',
                                        'ukazhite-temy-napravleniya-vashey',
                                        'Укажите темы, направления вашей работы, на которых вы хотели бы сделать акцент'
                                    ),
                                    rows: '2',
                                    style: 'resize: none'
                                }
                            }
                        }
                    }
                ]
            },
            {
                elem: 'list-col-click',
                content: u.formatInt(campaign.clicks)
            },
            {
                elem: 'list-col-left',
                content: [
                    u.formatInt(campaign.left),
                    campaign.walletIsEnabled && {
                        block: 'icon',
                        mix: {
                            block: 'b-campaign-optimizer-request',
                            elem: 'icon-help'
                        },
                        mods: {
                            'size-12': 'help',
                            theme: 'light'
                        }
                    }
                ]
            }
        ];
    })
);
