/**
 * Заявка на оптимизацию кампаний
 *
 * @param ctx.campaigns {Array} список кампаний
 * @param ctx.currencyNameShort {String} обозначение валюты
 *
 * @namespace b-campaign-optimizer-request
 */
block('b-campaign-optimizer-request')(

    js()(true),

    content()(function() {
        var ctx = this.ctx,
            campaigns = ctx.campaigns;

        return [
            {
                elem: 'list-head',
                currencyNameShort: ctx.currencyNameShort
            },
            campaigns.map(function(campaign, index) {
                return {
                    block: 'b-campaign-optimizer-request',
                    elem: 'list-row-content',
                    campaign: campaign,
                    num: index + 1
                }
            }),
            {
                block: this.block,
                elem: 'message',
                content: [
                    {
                        content: iget2(
                            'b-campaign-optimizer-request',
                            'kogda-my-zakonchim-rabotu',
                            'Когда мы закончим работу, в выбранной кампании появится раздел "Медиаплан" с готовыми ключевыми фразами и объявлениями'
                        ) + '.'
                    },
                    {
                        content: iget2(
                            'b-campaign-optimizer-request',
                            'vy-mozhete-perenesti-ih',
                            'Вы можете перенести их полностью или выборочно в существующую кампанию и сразу отправить на модерацию'
                        ) + '.'
                    },
                    {
                        content: iget2(
                            'b-campaign-optimizer-request',
                            'esli-zapros-budet-otpravlen',
                            'Если запрос будет отправлен в выходной день, мы обязательно рассмотрим его в ближайшие рабочие дни'
                        ) + '.'
                    },
                    {
                        content: iget2('b-campaign-optimizer-request', 'my-ostavlyaem-za-soboy', 'Мы оставляем за собой право отказать в выполнении заявки') + '.'
                    }
                ]
            },
            {
                elem: 'form',
                tag: 'form',
                attrs: {
                    method: 'POST',
                    action: '/registered/main.pl'
                },
                content: [
                    {
                        elem: 'data',
                        tag: 'input',
                        attrs: {
                            type: 'hidden',
                            name: 'json_order_info'
                        }
                    },
                    {
                        tag: 'input',
                        attrs: {
                            type: 'hidden',
                            name: 'cmd',
                            value: 'sendCampaignOptimizingEmail'
                        }
                    },
                    {
                        tag: 'input',
                        attrs: {
                            type: 'hidden',
                            name: 'ulogin',
                            value: u.consts('ulogin')

                        }
                    },
                    {
                        elem: 'order'
                    }
                ]
            }
        ];
    })
);
