/**
 * Заявка на оптимизацию рекламных кампаний
 */
BEM.DOM.decl('b-campaign-optimizer-request', {

    /**
     * @type {BEM} блок - кнопка отправки заявки
     */
    _actionOrder: null,

    onSetMod: {
        js: function() {
            this._actionOrder = this.findBlockInside('order', 'button');
            this.bindTo(this.elem('form'), 'submit', this._setData);
        }
    },

    /**
     * Возвращает состояние - валидно ли состояние
     * @return {Boolean}
     */
    isValid: function() {
        return this._isSelectedCampaignsValid();
    },

    /**
     * @override {BEM.DOM}
     */
    destruct: function() {
        this._tipman && this._tipman.destruct();
        return this.__base.apply(this, arguments);
    },

    /**
     * Устанавливает данные, которые будут отправлены на сервер
     * @private
     */
    _setData: function() {
        var data = this._getSelectedCampaigns().map(function(item) {
            return {
                cid: item.val(),
                comment: this.findBlockInside(this._getItemOrderNote(item.val()), 'input').val()
            };
        }, this);

        this.elem('data').val(JSON.stringify(data));
    },

    /**
     * Проверка валидности выбора кампаний
     * @returns {boolean}
     * @private
     */
    _isSelectedCampaignsValid: function() {
        var selectedLength = this._getSelectedCampaigns().length;

        return Boolean(selectedLength && selectedLength <= 2);
    },

    /**
     * Возвращает блоки выделенных checkbox
     * @return {BEM[]}
     * @private
     */
    _getSelectedCampaigns: function() {
        return this.findBlocksInside('list-row', 'checkbox').filter(function(cb) {
            return cb.isChecked();
        });
    },

    /**
     * Возвращает все блоки checkbox
     * @return {BEM[]}
     * @private
     */
    _getCampaigns: function() {
        return this.findBlocksInside('list-row', 'checkbox');
    },

    /**
     * Обрабатывает событие при изменении выбранных кампаний
     * @param {BEM} block чекбокс, в котором произошли изменения
     * @private
     */
    _onChangeSelected: function(block) {
        var selectedCampaignsLength = this._getSelectedCampaigns().length,
            campaigns = this._getCampaigns(),
            elemNote = this._getItemOrderNote(block.val());

        if (selectedCampaignsLength > 1) {
            campaigns.forEach(function(camp) {
                camp.isChecked() || camp.setMod('disabled', 'yes');
            });
        } else {
            campaigns.forEach(function(camp) {
                camp.delMod('disabled');
            });
        }
        if (block.isChecked()) {
            this.delMod(elemNote, 'hide');
        } else {
            this.setMod(elemNote, 'hide', 'yes');
        }
        this._changeDisableOrder(this.isValid());
    },

    /**
     * Изменяет состояние блокировки кнопки заказа
     * @param {Boolean} enable
     * @private
     */
    _changeDisableOrder: function(enable) {
        enable ? this._actionOrder.delMod('disabled') : this._actionOrder.setMod('disabled', 'yes');
    },

    /**
     * Возвращает элемент в котром размещено текстовое поле
     * @param {Number} cid
     * @returns {*|jQuery}
     * @private
     */
    _getItemOrderNote: function(cid) {
        return this.findElem('campaign-item-order-note', 'cid', '' + cid);
    },

    _tooltipShow: function(e) {
        this._tipman || (this._tipman = BEM.create('tipman', {
            tipMods: { theme: 'normal' },
            tipJs: { to: ['right'] },
            popupMods: { 'on-scroll': 'close' }
        }));

        this._tipman.show({
            owner: e.data.domElem,
            content: iget2('b-campaign-optimizer-request', 'summa-na-obshchem-schete', 'Сумма на общем счёте клиента')
        });
    },

    /**
     * Обработчик наведения курсора мышки на элемент ошибки
     * @param {jQuery.Event} e
     * @private
     */
    _onMouseOverOutHelp: function(e) {
        if (e.type === 'pointerover') {
            this._tooltipShow(e);
        } else {
            this._tipman && this._tipman.hide();
        }
    }
}, {
    live: function() {
        this
            .liveInitOnBlockInsideEvent('change', 'checkbox', function(e) {
                this._onChangeSelected(e.block);
            })
            .liveBindTo(
                'icon-help',
                'pointerover pointerout',
                function(e) {
                    this._onMouseOverOutHelp(e);
                });
    }
});
