block('b-campaign-period')(

    def()(function() {
        var campaign = this.ctx.campaign;

        return applyNext({
            start: campaign.start_date,
            finish: campaign.finish_date
        });
    }),

    js().match(function() {
        return this.ctx.isEditable;
    })(function() {
        return { dmParams: this.ctx.campaign.dmParams };
    }),

    mix()(function() {
        return {
            mods: { 'has-finish': this.finish ? 'yes' : 'no' }
        };
    }),

    elem('start').content()(function() {
        var isEditable = this.ctx.isEditable;

        return {
            block: 'b-date-input',
            mods: { disabled: isEditable ? undefined : 'yes' },
            name: 'start_date',
            value: this.start,
            dateFormat: 'YYYY-MM-DD',
            viewFormat: 'DD MMM YYYY'
        }
    }),

    elem('finish').content()(function() {
        var isEditable = this.ctx.isEditable;

        return {
            block: 'b-date-input',
            mods: { disabled: isEditable ? undefined : 'yes' },
            name: 'finish_date',
            value: this.finish,
            dateFormat: 'YYYY-MM-DD',
            viewFormat: 'DD MMM YYYY',
            earlierLimit: (function() {
                var monthsParse = u.moment.monthsShort(),
                    date = new Date();

                return date.getDate() + ' ' + monthsParse[date.getMonth()] + '' + date.getFullYear();
            })()
        }
    }),

    elem('start-label')(

        tag()('span'),

        content()(function() {
            var isEditable = this.ctx.isEditable;

            return iget2('b-campaign-period', 's-start-date', 'с{start-date}', {
                'start-date': {
                    elem: 'start',
                    isEditable: isEditable
                }
            })
        })
    ),

    elem('finish-label')(

        tag()('span'),

        content()(function() {
            var isEditable = this.ctx.isEditable;

            return iget2('b-campaign-period', 'do-end-date', 'до{end-date}', {
                'end-date': {
                    elem: 'finish',
                    isEditable: isEditable
                }
            })
        })
    ),

    content()(function() {
        var isEditable = this.ctx.isEditable;

        return [
            {
                elem: 'start-label',
                isEditable: isEditable
            },
            {
                elem: 'finish-label',
                isEditable: isEditable
            }
        ];
    }),

    content().match(function() {
        return this.ctx.isEditable;
    })(function() {
        var res = applyNext();

        return res.concat([
            {
                block: 'link',
                mods: {
                    inner: 'yes',
                    theme: 'toggler'
                },
                mix: [{
                    block: 'b-campaign-period',
                    elem: 'plus'
                }],
                content: [
                    {
                        block: 'icon',
                        mods: { 'size-16': 'plus', theme: 'light' },
                        mix: [{
                            block: 'link',
                            elem: 'icon'
                        }]
                    },
                    {
                        elem: 'inner',
                        content: iget2('b-campaign-period', 'data-okonchaniya', 'Дата окончания')
                    }
                ]
            },
            {
                block: 'link',
                mods: {
                    inner: 'yes',
                    theme: 'toggler'
                },
                mix: [{
                    block: 'b-campaign-period',
                    elem: 'remove'
                }],
                content: [
                    {
                        block: 'icon',
                        mods: { 'size-16': 'delete', theme: 'light' },
                        mix: [{
                            block: 'link',
                            elem: 'icon'
                        }],
                        attrs: { align: 'center' }
                    }
                ]
            }
        ]);
    })
);
