BEM.DOM.decl('b-campaign-period', {
    onSetMod: {
        js: function() {
            this.model = BEM.MODEL.getOne(this.params.dmParams);

            this
                .bindTo('plus', 'click', function() {
                    this.setMod('has-finish', 'yes');
                }.bind(this))
                .bindTo('remove', 'click', this._onRemoveFinishClick.bind(this));

            this.finish = this.findBlockInside('finish', 'b-date-input');
            this.finish && this.finish.on('change', function(e, date) {
                this.model.set('finish_date', date);
            }, this);

            this.start = this.findBlockInside('start', 'b-date-input');
            this.start && this.start.on('change', function(e, date) {
                this.model.set('start_date', date);
            }, this);
        },

        'has-finish': {
            no: function() {
                this.finish.val('');
            }
        }
    },

    /**
     * Обработчик клика по кнопке удаления поля окончания работы кампании
     * @private
     */
    _onRemoveFinishClick: function() {
        if (this.finish.val()) {

            BEM.blocks['b-confirm'].open({
                hideClose: true,
                message: iget2(
                    'b-campaign-period',
                    'data-okonchaniya-budet-sbroshena',
                    'Дата окончания будет сброшена. Показы будут идти до окончания денежных средств на кампании.'
                ),
                type: 'alert',
                onYes: function() {
                    this.setMod('has-finish', 'no');
                    this.model.set('finish_date', '');
                }.bind(this)
            }, this);

        } else {
            this.setMod('has-finish', 'no');
        }
    }
});
