/**
 * @param {Object} modelParams параметры модели кампании для данного блока
 * @param {String} modelParams.name
 * @param {String} modelParams.id
 */
block('b-campaign-platform-switcher')(
    def()(function() {
        var disabled = this.data.campaign.strategy.search.name == 'stop';

        return applyNext({
            disabled: disabled
        });
    }),

    content()(function() {
        return [{
            block: 'radio-button',
            mix: [{
                block: 'b-campaign-platform-switcher',
                elem: 'radio-button'
            }],
            name: 'platform',
            value: this.data.campaign.platform,
            content: [
                {
                    elem: 'radio',
                    controlAttrs: {
                        value: 'search'
                    },
                    elemMods: {
                        disabled: this.disabled ? 'yes' : undefined
                    },
                    content: iget2('b-campaign-platform-switcher', 'na-poiske', 'На поиске')
                },
                {
                    elem: 'radio',
                    controlAttrs: {
                        value: 'context'
                    },
                    content: iget2('b-campaign-platform-switcher', 'v-setyah', 'В сетях')
                }
            ]
        }];
    }),

    js()(function() {
        return !this.disabled && {
            modelParams: this.ctx.modelParams,
            bannersCount: this.data.banners.length
        };
    })
);
