BEM.DOM.decl('b-campaign-platform-switcher', {
    onSetMod: {
        js: function() {
            var _this = this;

            this.campModel = BEM.MODEL.getOne(this.params.modelParams);
            this.switcher = this.findBlockInside('radio-button');

            var count = this.params.bannersCount,
                groups = [0, 10, 50, 250, 500, 1000];

            this.group = 0;

            groups.forEach(function(limit, i) {
                var next = groups[i + 1];

                if (count == 0) return false;
                if (!next) {
                    this.group = limit;
                    return;
                }
                if (count > limit && count <= next) {
                    this.group = next;
                    return false;
                }
            }, this);

            this.switcher.on('change', function() {
                this.toggle(this.switcher.val());
            }, this);

        }
    },

    toggle: function(platform) {
        if (this.isDataChanged()) {
            this.getWarning().show(this.domElem);
            this.tmpPlatform = platform;
        } else {
            this.setPlatform(platform);
        }
    },

    isDataChanged: function() {
        return BEM.blocks['i-phrases-prices-helper'].getInstance('all', this.campModel).hasChangedModels();
    },

    setPlatform: function(platform) {
        this.switcher.val(platform);
        this.campModel.set('platform', platform, { source: this });
        BEM.blocks['i-utils'].campOptions.set('platform', platform);
        //TODO Включить счетчик, если будут запросы от менеджеров
        //Lego.cp(22, 72153, 'phrases-list-ctx-search-switcher-v2.' + this.group + '.' + this.campModel.get('cid'));
    },

    getWarning: function() {
        if (!this._warning) {
            this._warning = $(BEMHTML.apply({
                block: 'b-save-data-warning'
            })).appendTo(BEM.blocks['b-page'].getInstance().domElem).bem('b-save-data-warning');

            this._warning.on('continue', function() {
                BEM.blocks['b-campaign-edit-panel'].getInstance().rollback();
                this.setPlatform(this.tmpPlatform);
                this._warning.hide();
            }, this);

            this._warning.on('save', function() {
                var _this = this;
                BEM.blocks['b-campaign-edit-panel'].getInstance().save(function() {
                    _this.setPlatform(_this.tmpPlatform);
                    _this._warning.hide();
                });
            }, this);

            this._warning.on('cancel', function() {
                this.setPlatform(this.campModel.get('platform'));
                this._warning.hide();
            }, this)

        }

        return this._warning;
    }

}, {
    live: function() {
        this.liveInitOnBlockInsideEvent('init', 'radio-button');
    }
});
