block('b-campaign-region')(
    addJs()(true),

    content()(function() {
        var campaign = this.ctx.campaign,
            campaignGeoChanges = campaign.geo_changes || {},
            extendedGeo = campaign.extended_geo || {},
            regionsTreeInfo,
            geoState,
            useBanner = campaign.mediaType == 'mcbanner';

        // есть случай, если на сервере произошла ошибка и мы остались на той же странице
        // тогда все сделанные изменения в регионах приходят нам в geo_changes и нам надо соединить с extended_geo
        // для показа произведенного выбора пользователю
        if (campaignGeoChanges.merge_geo === 0) {
            extendedGeo = {};
        }

        Object.keys(campaignGeoChanges).forEach(function(regionId) {

            if (extendedGeo[regionId]) {
                delete extendedGeo[regionId].partly;

                extendedGeo[regionId].negative && delete extendedGeo[regionId].negative.partly;
            } else {
                extendedGeo[regionId] = {};
            }

            if (campaignGeoChanges[regionId].is_negative) {
                extendedGeo[regionId].negative = extendedGeo.negative || {};
                extendedGeo[regionId].negative.all = 1;

                delete extendedGeo[regionId].all;
            } else {
                extendedGeo[regionId].all = 1;
            }
        });

        regionsTreeInfo = u.getRegionsTreeInfo(
            u.getRegionsTree(this.data.lang + (this.data.translocal_tree_type === 'ru' ? '_for_ru' : '')),
            extendedGeo,
            {
                cid: campaign.cid,
                mediaType: campaign.mediaType,
                groupNames: campaign.pid_to_group_name || {}
            });

        geoState = regionsTreeInfo.treeStateValue;

        // DIRECT-67816: ТС: при создании кампании при повторном возвращении на страницу параметров получаем ошибку про регион
        if (this.data.new_camp && regionsTreeInfo.treeStateValue) {
            campaignGeoChanges = regionsTreeInfo.treeStateValue
                .split(',')
                .reduce(function(res, geoItem) {
                    res[Math.abs(geoItem)] = { is_negative: geoItem > 0 ? 0 : 1 };

                    return res;
                }, {});

            campaignGeoChanges.merge_geo = 0;
        }

        return [
            applyCtx({
                block: 'b-regions-selector',
                isEditable: this.ctx.isEditable,
                modelParams: {
                    name: 'm-geo-regions',
                    id: campaign.cid
                },
                mods: {
                    'with-validation': this.ctx.withCommonGeoValidation ? 'yes' : ''
                },
                mixes: this.ctx.mixes,
                regions: regionsTreeInfo.regions,
                geoState: geoState,
                geoText: !geoState ?
                    iget2('b-campaign-region', 'regiony-pokaza-ne-zadany', 'Регионы показа не заданы.') :
                    u.getGeoNames(geoState),
                geoChanges: campaignGeoChanges,
                productType: campaign.mediaType,
                // TODO DIRECT-67228: b-regions-tree:
                // TODO оптимизировать обход дерева и научится строить дерево по id-шникам регионов в любом порядке
                regionsTreeInfoParams: {
                    lang: this.data.lang + (this.data.translocal_tree_type === 'ru' ? '_for_ru' : ''),
                    cid: campaign.cid,
                    mediaType: campaign.mediaType,
                    groupNames: campaign.pid_to_group_name || {}
                },
                emptyText: iget2('b-campaign-region', 'regiony-pokaza-ne-zadany', 'Регионы показа не заданы.'),
                geoHiddenName: 'geo',
                hintAboveControl: this.ctx.hintAboveControl || false,
                hintMixes: this.ctx.hintMixes,
                disableRegions: campaign.product_type == 'mcb_regional' ? u.REGIONS.MCB_DISABLED_REGIONS : false,
                isCommon: true,
                bids: u.getBidsFromExtendedData(campaign.extended_geo),
                hasBidsCorrections: !u.campaign.isCpm(campaign.mediaType),
                disableEditBids: this.ctx.disableEditBids,
                isBidsCorrectionsModeOn: !!campaign.geo_multipliers_enabled,
                cid: campaign.cid,
                geoSuggestForQuickSelect: this.data.geo_suggest_for_quick_select,
                hintForDifferentRegions: useBanner ?
                    iget2(
                        'b-campaign-region',
                        'region-pokaza-kotoryy-vy',
                        'Регион показа, который вы хотите изменить, настроен по-разному в группах баннеров этой кампании. Например, в одной группе он выбран, а в другой нет. После внесения изменений во всех группах баннеров этот регион показа станет настроен одинаково. Например, станет выбран во всех группах.'
                    ) :
                    iget2(
                        'b-campaign-region',
                        'region-pokaza-kotoryy-vy-107',
                        'Регион показа, который вы хотите изменить, настроен по-разному в группах объявлений этой кампании. Например, в одной группе он выбран, а в другой нет. После внесения изменений во всех группах объявлений этот регион показа станет настроен одинаково. Например, станет выбран во всех группах.'
                    )
            }),
            {
                elem: 'warning',
                elemMods: {
                    visible: campaign.product_type == 'mcb_regional' ? 'yes' : ''
                }
            }
        ];
    }),

    elem('warning').content()(function() {
        return [
            {
                block: 'icon',
                mods: {
                    'size-13': 'alert'
                }
            },
            '&nbsp;',
            iget2(
                'b-campaign-region',
                'dlya-regionalnogo-mkb-moskovskaya',
                'Для регионального МКБ Московская и Ленинградская область недоступны для показа'
            )
        ];
    })
);
