/**
 * @event b-campaign-region#popup-show popup стал виден
 * @event b-campaign-region#popup-show save-click клик по кнопке "Сохранить"
 *
 * @fires b-campaign-region#popup-show popup
 * @fires b-campaign-region#popup-show save-click
 */
BEM.DOM.decl('b-campaign-region', {
    onSetMod: {
        js: function() {
            this.findBlockInside('b-regions-selector')
                .on('open-popup', function() {
                    this.trigger('popup-show');
                }, this)
                .on('save', function() {
                    this.trigger('save-click');
                }, this);
        }
    },

    /**
     * Показать/скрыть предупреждение
     * @param {Boolean} state состояние
     */
    toggleWarning: function(state) {
        this.setMod(this.elem('warning'), 'visible', state ? 'yes' : '');
    }
});
