block('b-campaign-settings-header')(

    def()(function() {
        var data = this.data,
            campaign = data.campaign;

        return {
            name: campaign.OrderID && campaign.OrderID !== '0' && {
                block: 'b-campaign-settings-header',
                elem: 'stat-link',
                cid: campaign.cid,
                login: data.uid_url.value
            },
            mixes: [{ block: 'b-campaign-settings', elem: 'header-group' }],
            cells: [
                data.new_camp ?
                    applyCtx({ elem: 'new-camp' }) :
                    applyCtx({
                        elem: 'old-camp',
                        isEditable: this.ctx.isEditable
                    }),
                [
                    applyCtx({
                        elem: 'campaign-type'
                    })
                ]
            ]
        };
    }),

    elem('campaign-type').content()(function() {
        return {
            block: 'b-campaign-type',
            mediaType: this.data.campaign.mediaType
        };
    }),

    elem('new-camp').content()(function() {
        var data = this.data,
            campaign = data.campaign,
            mediaType = campaign.mediaType;

        return [
            (!mediaType || mediaType === 'text' || mediaType === 'mobile_content') &&
                iget2('b-campaign-settings-header', 'shag-1-iz-2', 'Шаг 1 из 2'),
            {
                block: 'b-page-title',
                mix: {
                    block: 'b-campaign-settings-header',
                    elem: 'title'
                },
                title: iget2('b-campaign-settings-header', 'sozdanie-kampanii', 'Создание кампании')
            }
        ];
    }),

    elem('old-camp').content()(function() {

        var data = this.data,
            campaign = data.campaign,
            mediaTypeText = campaign.mediaTypeText;

        return [
            campaign.statusEmpty == 'Yes' && campaign.exported != 'Yes' && iget2('b-campaign-settings-header', 'shag-3-iz-3', 'Шаг 3 из 3'),
            {
                block: 'b-page-title',
                mix: {
                    block: 'b-campaign-settings-header',
                    elem: 'title'
                },
                title: [
                    iget2('b-campaign-settings-header', 'parametry-kampanii', 'Параметры кампании'),
                    '&nbsp;&laquo;',
                    applyCtx({
                        block: 'b-campaign-settings-header',
                        elem: 'name',
                        isEditable: this.ctx.isEditable,
                        content: u.escapeHTML((campaign.name || '').trim())
                    }),
                    '&raquo;,&nbsp;&#8470;&nbsp;',
                    campaign.cid
                ]
            },
            mediaTypeText && {
                block: 'b-campaign-settings-header',
                elem: 'media-type-text',
                content: mediaTypeText
            }
        ];
    }),

    elem('stat-link').content()(function() {
        return this.ctx.content || '&nbsp;';
    }),

    elem('name').match(function() {
        return this.ctx.isEditable;
    }).wrap()(function() {
        var data = this.data,
            campaign = data.campaign;

        return {
            block: 'link',
            mix: { block: 'b-campaign-settings-header', elem: 'name' },
            url: u.getUrl('showCamp', {
                cid: campaign.cid,
                ulogin: data.uid_url.value
            }),
            content: this.ctx.content
        };
    })
);
