block('b-campaign-settings').elem('item').elemMod('of', 'adjustment-rates')(
    def()(function() {
        var campaign = this.data.campaign,
            mediaType = campaign.mediaType,
            isMCBanner = mediaType === 'mcbanner',
            adjustmentModelId = campaign.cid || 'new_camp';

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: iget2('b-campaign-settings', 'korrektirovki-stavok', 'Корректировки ставок'),
                help: u.getHelpUrl(isMCBanner ? 'bids-adjustment-search' : 'bids-adjustment')
            },
            right: this.mods.edit === 'yes' || u.consts('rights').campaignSettingsWidgetsForSuperEnabled ?
                [
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-adjustment-rates',
                            id: adjustmentModelId,
                            data: campaign.hierarchicalMultipliers
                        }
                    },
                    {
                        block: 'b-adjustment-rates-popup',
                        modelId: adjustmentModelId,
                        defaultTab: (this.ctx.data || {}).defaultTab || 'retargeting',
                        tabsHash: (this.ctx.data || {}).tabsHash || u['b-adjustment-rates-popup'].getTabsHash({
                            retargeting: true,
                            mobile: !isMCBanner,
                            devices: u._.includes(['cpm_banner', 'cpm_deals'], campaign.mediaType) ||
                                (hasEnabledFeatures('cpc_device_modifiers') || u.consts('isMobileOsBidModifierEnabled')) &&
                                    u._.includes(['text', 'dynamic', 'performance', 'content_promotion'], campaign.mediaType),
                            video: campaign.mediaType === 'text',
                            demography: true,
                            performanceTGO: mediaType === 'performance',
                            hasRetargetingConditions: u.retargeting.hasRetargetingConditions(
                                this.data.all_retargeting_conditions,
                                'metrika_goals'
                            )
                        }),
                        modal: true,
                        mix: [{
                            block: 'b-metrika2',
                            js: {
                                goals: [
                                    {
                                        event: 'popup-show',
                                        target: 'EditCamp.Bid_adjustments.Popup'
                                    },
                                    {
                                        event: 'save-click',
                                        target: 'EditCamp.Bid_adjustments.Popup.Save'
                                    }
                                ],
                                blockName: 'b-adjustment-rates-popup'
                            }
                        }],
                        content: [
                            {
                                elem: 'hidden-input'
                            },
                            {
                                elem: 'rates',
                                modelData: campaign.hierarchicalMultipliers,
                                hintMixes: [{
                                    block: 'b-campaign-settings',
                                    elem: 'hint'
                                }]
                            },
                            {
                                elem: 'switcher',
                                theme: 'normal',
                                content: iget2('b-campaign-settings', 'dobavit', 'Добавить')
                            }
                        ]
                    }
                ] :
                applyCtx({
                    block: 'b-adjustment-rates-view-only'
                })
        };
    })
);
