block('b-campaign-settings').elem('item').elemMod('of', 'allowed-frontpage-types')(
    def()(function() {
        var frontpageTypesText = {
                frontpage: iget2('b-campaign-settings', 'main-page-site', 'Десктоп'),
                frontpage_mobile: iget2('b-campaign-settings', 'mobile-main-site', 'Мобильная'),
                browser_new_tab: iget2('b-campaign-settings', 'browser-new-tab', 'Новая вкладка Браузера'),
            },
            campaignFrontpageTypes = this.data.campaign.allowed_frontpage_types || [],
            enabledFrontpageTypes = ['frontpage', 'frontpage_mobile', 'browser_new_tab'],
            selectedFrontpageTypes;

        if (campaignFrontpageTypes.length) {
            if (typeof campaignFrontpageTypes === 'string') {
                selectedFrontpageTypes = campaignFrontpageTypes.split(',');
            } else if (Array.isArray(campaignFrontpageTypes)) {
                selectedFrontpageTypes = campaignFrontpageTypes;
            }
        } else {
            selectedFrontpageTypes = enabledFrontpageTypes;
        }

        return {
            mixes: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: [
                    iget2('b-campaign-settings', 'site-version', 'Версия сайта'),
                    '&nbsp;',
                    {
                        block: 'b-mark-required'
                    }
                ]
            },
            right: this.mods.edit === 'yes' ? [
                {
                    block: 'select2',
                    mods: {
                        type: 'check',
                        theme: 'normal',
                        size: 's',
                        text: 'vary'
                    },
                    mix: {
                        block: 'b-campaign-settings',
                        elem: 'frontpage-types-select',
                        elemMods: { 'browser-new-tab': 'allowed' }
                    },
                    menu: {
                        mix: {
                            block: 'b-campaign-settings',
                            elem: 'frontpage-types-menu'
                        }
                    },
                    text: iget2('b-campaign-settings', 'choose-allowed-frontpage-types', 'Место размещения'),
                    name: 'allowed_frontpage_types',
                    val: selectedFrontpageTypes,
                    items: enabledFrontpageTypes.map(function(type) {
                        return {
                            val: type,
                            elemMods: {
                                disabled: selectedFrontpageTypes.length === 1 &&
                                    u._.includes(selectedFrontpageTypes, type) ? 'yes' : ''
                            },
                            text: frontpageTypesText[type]
                        }
                    })
                },
                {
                    block: 'b-campaign-settings',
                    elem: 'hiddens',
                    fields: {
                        // ignore stringify
                        allowed_frontpage_types: JSON.stringify(selectedFrontpageTypes)
                    }
                }
            ] : selectedFrontpageTypes.map(function(t) { return frontpageTypesText[t]; }).join((', '))
        };
    })
);
