block('b-campaign-settings').elem('item').elemMod('of', 'allowed-page-ids')(
    def()(''),
    def().match(function() {
        return this.data.allowed_page_ids_feature_enabled;
    })(function() {
        var data = this.data;

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: iget2('b-campaign-settings', 'pokazivat-tolko-na-ukazannich-pageId', 'Показывать только на указанных PageIds')
            },
            right: this.mods.edit === 'yes' ?
                [
                    {
                        block: 'input',
                        mods: {
                            type: 'textarea'
                        },
                        mix: [
                            {
                                block: 'b-campaign-settings',
                                elem: 'model-field',
                                js: {
                                    name: 'allowed_page_ids',
                                    type: 'input'
                                }
                            }
                        ],
                        value: data.campaign.allowed_page_ids && u.escapeHTML(data.campaign.allowed_page_ids),
                        placeholder: iget2('b-campaign-settings', 'id-ploschadok-dlya-pokaza-cherez-zapyatuyu', 'Id площадок для показа (через запятую)'),
                        content: {
                            elem: 'control',
                            attrs: {
                                tabindex: '1',
                                name: 'allowed_page_ids',
                                rows: 4
                            }
                        }
                    },
                    {
                        block: 'b-model-form-error',
                        mix: [{
                            block: 'b-model-form-error',
                            elem: 'control'
                        }],
                        modelParams: this.modelParams,
                        field: 'allowed_page_ids'
                    }
                ] :
                {
                    block: 'b-campaign-settings',
                    elem: 'hint',
                    content: data.campaign.allowed_page_ids ?
                        u.escapeHTML(data.campaign.allowed_page_ids) :
                        iget2('b-campaign-settings', 'ne-zadano', 'Не задано')
                }
        };
    })
);
