block('b-campaign-settings').elem('item').elemMod('of', 'alone-trafaret')(
    def()(''),

    def().match(function() {
        return !!this.data.features_enabled_for_client.alone_trafaret_option_enabled;
    })(function() {
        var campaign = this.data.campaign,
            disabled = campaign.strategy2.is_search_stopped,
            value = campaign.opts.is_alone_trafaret_allowed;

        return {
            mixes: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: [
                {
                    block: 'checkbox',
                    mix: [
                        { block: 'b-campaign-settings', elem: 'alone-trafaret-checkbox' }
                    ],
                    mods: {
                        checked: value ? 'yes' : '',
                        disabled: (this.mods.edit === 'yes' && !disabled) ? undefined : 'yes'
                    },
                    text: {
                        content: iget2('b-campaign-settings', 'alone-trafaret', 'Показываться в тестовых трафаретах 881 и 841')
                    }
                }, {
                    block: 'b-hidden',
                    mix: { block: this.block, elem: 'hidden-alone-trafaret' },
                    attrs: {
                        name: 'is_alone_trafaret_allowed',
                        value: value
                    }
                }, {
                    block: 'tooltip',
                    mix: [
                        { block: 'b-campaign-settings', elem: 'alone-trafaret-tooltip' }
                    ],
                    mods: {
                        size: 'xs',
                        theme: 'white',
                    },
                    js: {
                        to: ['right']
                    },
                    content: iget2('b-campaign-settings', 'search-only-setting', 'Настройка работает в кампаниях на поиске')
                }
            ]
        };
    })
);
