block('b-campaign-settings').elem('item').elemMod('of', 'banners-per-page')(
    def()(function() {
        var campaign = this.data.campaign,
            bannersPerPage = u.escapeHTML(+campaign.banners_per_page || 5),
            useBanner = campaign.mediaType === 'mcbanner' || campaign.mediaType === 'content_promotion';

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: useBanner ?
                iget2('b-campaign-settings', 'kolichestvo-grupp-bannerov-na', 'Количество групп баннеров на странице кампании') :
                iget2('b-campaign-settings', 'kolichestvo-grupp-obyavleniy-na', 'Количество групп объявлений на странице кампании'),
            right: this.mods.edit === 'yes' ?
                {
                    block: 'input',
                    mix: [{
                        block: 'b-campaign-settings',
                        elem: 'banners-per-page'
                    }],
                    content: {
                        elem: 'control',
                        attrs: {
                            tabindex: 1,
                            name: 'banners_per_page',
                            value: bannersPerPage
                        }
                    }
                } :
                bannersPerPage
        };
    })
);
