block('b-campaign-settings').elem('item').elemMod('of', 'brand-lift')(
    def()(function() {
        var data = this.data,
            campaign = data.campaign,
            brandSurveyId = campaign.brand_survey_id;

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: [
                    iget2(
                        'b-campaign-settings',
                        'brand-lift',
                        'Brand Lift'
                    ),
                    {
                        block: 'b-beta',
                        mods: { type: 'symbol' }
                    }
                ],
                help: u.getHelpUrl('brand-lift'),
                required: true
            },
            right: [
                {
                    block: 'brand-lift-control',
                    mods: {
                        open: data.FORM.open_brand_lift ? 'immediately' : undefined
                    },
                    modelParams: this.modelParams,
                    brandSurveyId: brandSurveyId,
                    clientId: campaign.ClientID || data.ClientID,
                    currency: campaign.currency
                },
                {
                    block: 'b-model-form-error',
                    mix: { block: 'b-model-form-error', elem: 'control' },
                    modelParams: this.modelParams,
                    field: 'brand_survey_id'
                },
                {
                    block: 'b-campaign-settings',
                    elem: 'hiddens',
                    fields: { brand_survey_id: brandSurveyId }
                }
            ]
        };
    })
);
